<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\LeadBookingService\Domain\LeadBookingServiceRepository;
use App\Modules\LeadBookingService\Infraestructure\MysqlLeadBookingServiceRepository;

$router->post(
    '/leadBookingService',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceInsertController@__invoke'
    ]
);

$router->put(
    '/leadBookingService',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceUpdateController@__invoke'
    ]
);

$router->delete(
    '/leadBookingService/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceDeleteController@__invoke'
    ]
);

$router->get(
    '/leadBookingService/{Id:[0-9]*}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceIndexController@__invoke'
    ]
);

$router->get(
    '/leadBookingTour/{Id_LeadBookingTour:[0-9]*}/leadBookingService/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'LeadBookingService\\LeadBookingServiceListController@__invoke'
    ]
);

$app->bind(LeadBookingServiceRepository::class, fn($app) => $app->make(MysqlLeadBookingServiceRepository::class));
