<?php

/** @var \Laravel\Lumen\Routing\Router $router */

$router->get(
    '/group/reviewToken',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@GenerateReviewLink'
    ]
);
$router->get(
    '/group/groupReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group\\ReviewList@__invoke'
    ]
);

$router->post(
    '/group',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Insert'
    ]
);
$router->post(
    '/group/full',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Insert_Full'
    ]
);
$router->put(
    '/group',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Update'
    ]
);
$router->put(
    '/group/remark',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Remark'
    ]
);
$router->put(
    '/group/status',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Status'
    ]
);
$router->delete(
    '/group/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Delete'
    ]
);
$router->get(
    '/group/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Selector'
    ]
);
$router->get(
    '/group/search/passenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Search_Passenger'
    ]
);
$router->get(
    '/group/search/providerPassenger',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'Group\\ProviderPassenger@__invoke'
    ]
);

$router->get(
    '/group/report/paginated',
    [
        'uses' => 'c_Group@Report_Paginated'
    ]
);
$router->get(
    '/group/report/unitary',
    [
        'uses' => 'c_Group@reportUnitary'
    ]
);

$router->get(
    '/group/report/excel',
    [
        'uses' => 'c_Group@Report_Excel'
    ]
);
$router->get(
    '/group/report/unitary/excel',
    [
        'uses' => 'c_Group@Report_Excel_Group'
    ]
);
$router->get(
    '/group/{Id}/review/excel',
    [
        'uses' => 'c_Group@Report_Excel_Review'
    ]
);

$router->get(
    '/group/report/pdf',
    [
        'uses' => 'c_Group@Report_Group_List_Pdf'
    ]
);
$router->get(
    '/group/report/unitary/pdf',
    [
        'uses' => 'c_Group@Report_Group_Pdf'
    ]
);
$router->get(
    '/group/{Id}/review/pdf',
    [
        'uses' => 'c_Group@Report_Group_Review_Pdf'
    ]
);
$router->get(
    '/group/{Id}/mail',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Send_Review_Mail'
    ]
);

$router->post(
    '/group/slave/all',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Slave_Insert_All'
    ]
);
$router->post(
    '/group/slave',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Slave_Insert'
    ]
);
$router->delete(
    '/group/slave/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Slave_Delete'
    ]
);
$router->get(
    '/group/{Id}/slave',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Slave_List'
    ]
);
$router->get(
    '/group/{Id}/slaveAll',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Slave_List_Complete'
    ]
);
$router->get(
    '/group/{Id}/slave/search',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'c_Group@Slave_Search'
    ]
);
