<?php

use App\Http\Constants\BookingConstants;
use App\Http\Controllers\Mail\c_Mail_Body;
use App\Http\Controllers\Mail\c_Mail_Structure;
use App\Http\Controllers\Mail\c_Mail_Term;
use App\Http\Controllers\Mail\c_Mail_Table;
use App\Http\Helpers\DateTime;

$oMail_Body = new c_Mail_Body;
$oMail_Structure = new c_Mail_Structure;
$oMail_Term = new c_Mail_Term;

$HeadFunction = function ($head) use ($oMail_Body) { return $oMail_Body->Get_Head ($oMail_Body->Get_H4_2($head)); };
$CellFunction = function ($cell) use ($oMail_Body) { return $oMail_Body->Get_Cell ($oMail_Body->Get_P ($cell, 'LEFT')); };

$PrintObligatory = function ($fee) { return $fee->InvoiceFee_Full == 2 && $fee->InvoiceFee_Amount - $fee->InvoiceFee_AmountPay > 0; };

$booking = $Content['Booking'];

//
//  OBTENEMOS TERMINOS EN UN IDIOMA
//
$Term			= $oMail_Term->Get_Term($Content["Lang"]);

$Title			= $Term["Booking_Title"];
$Message		= $Term["Booking_Message"];
$Signature      = $Term["Signature"];

$Mail_Body 		= $oMail_Body->Get_Booking_Body();
$Mail_Content   = $oMail_Body->Get_H1($Title);
$Mail_Content   .= $oMail_Body->Get_P($Message,"LEFT");

$urlType = $Content['ResourcesUrl'];
if ($booking->User_Type == 2) {
    $urlType .= 'mail/Reserva_Endosador.png';
} else {
    if ($booking->Booking_Type == 1) {
        $urlType .= 'mail/Reserva_Usuario_Web.png';
    } else {
        if ($booking->Booking_InPerson == 2) {

            $urlType .= 'mail/Reserva_Usuario_Oficina.png';
        } else {
            $urlType .= 'mail/Reserva_Usuario_Correo.png';
        }
    }
}

$Mail_Content   .= $oMail_Structure->Get_Subtitle ('<img style="height:14px;" src="' . $urlType . '" /> BOOKING CONFIRMATION - ' . $booking->Booking_Code, 'LEFT');

$Mail_Content   .= createTourTable ($booking);
$Mail_Content   .= $oMail_Body->Get_P(' ', 'LEFT');
$Mail_Content   .= createUserTable ($booking);
$Mail_Content   .= $oMail_Body->Get_P(' ', 'LEFT');
$Mail_Content   .= createPaxTable ($booking->Passengers);
$Mail_Content   .= $oMail_Body->Get_P(' ', 'LEFT');
$Mail_Content   .= createTourInformationTable ($booking->InvoiceDetailAll, $booking);

$Mail_Content   .= $oMail_Structure->Get_Subtitle ('<img style="height:14px; width:30px;" src="' . $urlType . '" /> BOOKING CONFIRMATION - ' . $booking->Booking_Code, 'LEFT');

function createTourTable ($booking) {
    $tourTable = c_Mail_Table::table();

    $rows = [];
    $rows = array_merge ($rows, mapTourList ($booking->Tour));
    $rows = array_merge ($rows, mapFlightList ($booking->Flight));

    addToTable ([['TOUR', 'DEPARTURE DATE']], $tourTable, 'dark');
    addToTable ($rows, $tourTable, 'base');
    return $tourTable;
}

function mapTourList ($tourList) {
    return array_map ( function ($tour) {
        return [
            $tour->BookingTour_TourName,
            DateTime::dateTransform($tour->BookingTour_DateStart)
        ];
    }, $tourList );
}

function mapFlightList ($flightList) {
    return array_map ( function ($flight) {
        $cell1 = $flight->Flight_Type == 2 ? 'TRANSFER OUT ' : 'TRANSFER IN';
        $cell1 .= "$flight->Flight_Carrier $flight->Flight_Number ($flight->Flight_Origin-$flight->Flight_Destination)";
        return [
            $cell1,
            DateTime::dateTimeTransform($flight->Flight_DateArrival)
        ];
    }, $flightList );
}

function createUserTable ($booking) {

    $userTable = c_Mail_Table::table();

    $userTable
        ->basicRow([
            c_Mail_Table::orangeColumn('Briefing Session')->setFontSize('.8em'),
            c_Mail_Table::baseColumn (bookingSession ($booking))
                ->setColspan(3)
                ->setFontSize('.8em')
        ])
        ->basicRow ([
            c_Mail_Table::orangeColumn('Contact Name')->setFontSize('.8em'),
            c_Mail_Table::baseColumn("$booking->User_Name $booking->User_LastName")->setFontSize('.8em'),
            c_Mail_Table::orangeColumn('Whatsapp')->setFontSize('.8em'),
            c_Mail_Table::baseColumn("+$booking->User_PhoneCode $booking->User_Phone")->setFontSize('.8em'),
        ])
        ->basicRow ([
            c_Mail_Table::orangeColumn('Number of Pax')->setFontSize('.8em'),
            c_Mail_Table::baseColumn(count($booking->Passengers))->setFontSize('.8em'),
            c_Mail_Table::orangeColumn('Language')->setFontSize('.8em'),
            c_Mail_Table::baseColumn($booking->GuideLanguage_Name)->setFontSize('.8em'),
        ])
        ->basicRow ([
            c_Mail_Table::orangeColumn('Email')->setFontSize('.8em'),
            c_Mail_Table::baseColumn($booking->User_Email)
                ->setColspan(3)
                ->setFontSize('.8em')
        ])
        ->basicRow ([
            c_Mail_Table::orangeColumn('Hotel in Cusco')->setFontSize('.8em'),
            c_Mail_Table::baseColumn($booking->Booking_Hotel)
                ->setFontSize('.8em')
                ->setColspan(3),
        ])
        ->basicRow ([
            c_Mail_Table::orangeColumn('Room Type')->setFontSize('.8em'),
            c_Mail_Table::baseColumn(getRoomsResume ($booking->Room))
                ->setFontSize('.8em')
                ->setColspan(3),
        ]);
    return $userTable;
}

function createPaxTable ($paxList) {
    $paxTable = c_Mail_Table::table();

    $paxTable ->basicRow([ c_Mail_Table::baseColumn ('PAX INFORMATION')->setAlign('center')->setColspan(7)->setBold() ]);
    addToTable ([['Name', 'Surname', 'M/F', 'DOB(DD/MM/YY)', 'Age', 'Passport', 'Country']], $paxTable, 'dark');
    addToTable (mapPaxList($paxList), $paxTable);
    return $paxTable;
}

function createTourInformationTable($invoiceDetailAll, $booking) {
    
    $paxTable = c_Mail_Table::table();

    $paxTable->basicRow([ c_Mail_Table::baseColumn ('TOUR INFORMATION')->setAlign('center')->setColspan(6)->setBold() ]);
    addToTable([['Start', 'Package', 'Inc', 'Unit Price', 'Qty.', '(USD) Total']], $paxTable, 'orange');

    $rows = [];
    $invoiceTotal = 0;

    foreach ($invoiceDetailAll as $detail) {
        if ($detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypePackage) {
            $detail->datePackage = searchMinTourDate ($detail->InvoiceDetail_Group, $booking);
        } else {
            $detail->datePackage = '';
        }
        
        if ($booking->User_Type == BookingConstants::User_TypeEndorser &&
            $detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypeIGV){
            $invoiceTotal += $detail->InvoiceDetail_Total;
        } else {
            $rows[] = [
                !$detail->datePackage ? '' : DateTime::dateTransform($detail->datePackage),
                $detail->InvoiceDetail_Description,
                $detail->InvoiceDetail_Included == 1 ? "" : $detail->InvoiceDetail_Quantity,
                $detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypeIGV ? "" : (round($detail->InvoiceDetail_Price * 100)) / 100,
                $detail->InvoiceDetail_Type == BookingConstants::InvoiceDetail_TypeIGV ? "" : $detail->InvoiceDetail_Quantity,
                round($detail->InvoiceDetail_Total * 100) / 100,
            ];
        }
    }

    addToTable ($rows, $paxTable);
    $paxTable->basicRow([ c_Mail_Table::baseColumn ('<br />')->setAlign('center')->setColspan(6) ]);

    $texttot = 'TOTAL';
    $valtot = $booking->InvoiceRes['Total'];
    $rows = 1;
    $obser = '';

    if ($booking->User_Type == 2) {
        $texttot = "Tours Balance";
        $valtot -= $invoiceTotal;
        $rows = 5;
        $obser = "OBSERVACION:" . $booking->Booking_Observation;
    }
    $paxTable->basicRow([
        c_Mail_Table::baseColumn($obser)->setColspan(3)->setRowspan($booking->User_Type == 2 ? 3 : 1),
        c_Mail_Table::orangeColumn($texttot)->setColspan(2)->setBold(),
        c_Mail_Table::baseColumn(round ($valtot * 100) / 100)->setAlign('right')
    ]);

    if ($booking->User_Type == 2) {
        $sumpays = 0;
        foreach ($booking->PayAll as $pay) {
            $sumpays += $pay->CashMovementDetail_Amount;
        }
        
        $paxTable->basicRow([
            c_Mail_Table::orangeColumn('IGV')->setColspan(2)->setBold(),
            c_Mail_Table::baseColumn(round ($invoiceTotal * 100) / 100)->setAlign('right')
        ]);
        $paxTable->basicRow([
            c_Mail_Table::orangeColumn('Total')->setColspan(2)->setBold(),
            c_Mail_Table::baseColumn(round (($valtot + $invoiceTotal) * 100) / 100)->setAlign('right')
        ]);

    }

    foreach ($booking->PayAll as $pay) {
        $paxTable->basicRow([
            c_Mail_Table::baseColumn("$pay->TypePayment_Name: " .
                CashMovementHelper::changeReceiptNumber($pay) .
                " ($pay->CashMovement_Amount )")
                ->setColspan(3),
            c_Mail_Table::orangeColumn("Deposit")->setColSpan(2)->setBold(),
            c_Mail_Table::baseColumn(round ($pay->CashMovementDetail_Amount * 100) / 100)->setAlign('right')
        ]);
    }
    
    $paxTable->basicRow([
        c_Mail_Table::baseColumn('')->setColspan(3),
        c_Mail_Table::darkColumn("BALANCE")->setColSpan(2)->setBold(),
        c_Mail_Table::baseColumn(round ($booking->InvoiceRes['TotalPending'] * 100) / 100)->setAlign('right')
    ]);
    
    if ($booking->User_Type != 2) {
        
        $paxTable->basicRow([
            c_Mail_Table::orangeColumn($booking->Admin_Abrv)->setColspan(6)->setAlign('center')->setBold()
        ]);
    }
    return $paxTable;
}

function searchMinTourDate ($group, $booking) {
    return array_reduce ($booking->Tour, function ($prev, $tour) use ($group) {
        if ($tour->BookingTour_Group != $group) {
            return $prev;
        }
        if ($prev == null) {
            return $tour->BookingTour_DateStart;
        }
        
        return (strtotime ($prev) < strtotime ($tour->BookingTour_DateStart)) ? $prev : $tour->BookingTour_DateStart;
    }, null);
}

function getRoomsResume ($roomList) {
    $roomAmounts = (object) [];
    $text = '';

    foreach ($roomList as $i => $room) {
        $key = $room->Id_TypeRoom;
        if (isset($roomAmounts->$key)) {
            $roomAmounts->$key->count++;
        } else {
            $roomAmounts->$key = (object)[
                'Id_TypeRoom'   => $room->Id_TypeRoom,
                'index'     => $i,
                'count'     => 1
            ];
        }
    }
    $i = 0;
    foreach ($roomAmounts as $key => $amount) {
        $text .= ($i == 0 ? '' : ', ') . str_pad ($amount->count, 2, '0', STR_PAD_LEFT) . ' ' . $roomList[$amount->index]->TypeRoom_Name;
        $i++;
    }
    return $text;
}

function bookingSession ($booking) {
    return DateTime::dateTimeTransform($booking->Booking_DateBriefing) . '(' . $booking->Booking_PlaceBriefing . ')';
}

function mapPaxList ($paxList) {
    return array_map (function ($pax) {
        return [
            $pax->Passenger_Name,
            $pax->Passenger_LastName,
            $pax->Passenger_Gender == '1' ? 'M' : 'F',
            DateTime::dateTransform($pax->Passenger_DOB),
            $pax->Passenger_Age,
            $pax->Passenger_NoDocument,
            $pax->UserCountry_Name
        ];
    }, $paxList);
}

function addToTable ($rows, &$table, $type = 'base') {
    foreach ($rows as $row) {
        $tableRow = c_Mail_Table::row();
        $table->addRow($tableRow);
        foreach ($row as $col) {
            switch ($type) {
                case 'base':
                    $tableRow->addColumn(c_Mail_Table::baseColumn($col)->setFontSize('.86em'),);
                    break;
                case 'dark':
                    $tableRow->addColumn(c_Mail_Table::darkColumn($col));
                    break;
                case 'orange':
                    $tableRow->addColumn(c_Mail_Table::orangeColumn($col));
                    break;
            }
            
        }
    }
}


$Mail_Content   .= $oMail_Body->Get_P($Signature,"RIGHT");

$Mail_Body      = str_replace("[[CONTENT]]", $Mail_Content, $Mail_Body);
$Mail_Body      = str_replace("[[MEDIA_HEADER]]", $Content["ResourcesUrl"] . 'mail/Mail_Header.png', $Mail_Body);
$Mail_Body      = str_replace("[[VOTE_FOR_US_FOOTER]]", $Content["ResourcesUrl"] . 'mail/vote-for-us.jpg', $Mail_Body);
echo $Mail_Body;

//{{ $Content['Password'] }}
