<?php

namespace App\Providers;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\ServiceProvider;

class MailConfigProvider extends ServiceProvider {

    public function boot() { }

    public function register() {
        try {
            $credentials = BookingMailSender::getCredentialList();
            $host = BookingMailSender::filterCredential($credentials, 'Email_Host')[0]->Credential_Value;
            $port = BookingMailSender::filterCredential($credentials, 'Email_Port')[0]->Credential_Value;
            $user = BookingMailSender::filterCredential($credentials, 'Email_Username')[0]->Credential_Value;
            $pass = BookingMailSender::filterCredential($credentials, 'Email_Password')[0]->Credential_Value;
            $from = BookingMailSender::filterCredential($credentials, 'Email_FromAddress')[0]->Credential_Value;
            $name = BookingMailSender::filterCredential($credentials, 'Email_FromName')[0]->Credential_Value;
            $encryption = BookingMailSender::filterCredential($credentials, 'Email_Encryption')[0]->Credential_Value;

            
            $config = [
                'driver'     => env('MAIL_DRIVER', 'smtp'),
                'host'       => $host,
                'port'       => $port,
                'from'       => [ 'address' => $from, 'name' => $name ],
                'encryption' => $encryption,
                'username'   => $user,
                'password'   => base64_decode($pass),
                'pretend'    => false,
            ];

            Config::set('mail', $config);
        } catch (\Throwable $th) {
        }
    }

}