<?php

namespace App\Providers\ExcelGroupUnitaryReport;

class PassengerPage {

    public static function text($text) { return [['action' => 'print', 'text' => $text], ['action' => 'wrap'], ['action' => 'top']]; }

    public function run ($oGroup, $oData) {
        $height = 11;
        
        if($oGroup->Group_ServiceType>2){
            $height = 14;
        }
        if($oGroup->Group_ServiceType==2){
            $height = 13;
        }
        $height++;
        $oPassengers = $oGroup->Passenger;
        $result = [];
        for ($i = 0; $i < $height - 1; $i++) {
            $result[] = [];
        }
        
        // if($oGroup->Group_ServiceType>2){
        //     $result[] = [
        //         [[ 'action' => 'print', 'text' => 'VUELO:' ], ['action' => 'merge','lines'=>1],['action' => 'bold']],
        //         [[ 'action' => '' ]],
        //         [[ 'action' => 'print', 'text' => $oGroup->Fligth[4] ],['action' => 'merge','lines'=>4]],
        //         [[ 'action' => 'advance', 'lines' => 0]],
        //         [[ 'action' => 'print', 'text' => 'NUMERO DE VUELO' ], [ 'action' => 'bold' ]],
        //         [[ 'action' => 'print', 'text' => $oGroup->Fligth[3] ]], 
        //     ];
        //     $result[] = [
        //         [[ 'action' => 'print', 'text' => 'ORIGEN:' ],['action' => 'merge','lines'=>1], ['action' => 'bold']],
        //         [[ 'action' => '' ]],
        //         [[ 'action' => 'print', 'text' => $oGroup->Fligth[1] ],['action' => 'merge','lines'=>4]],
        //         [[ 'action' => 'advance', 'lines' => 0]],
        //         [[ 'action' => 'print', 'text' => 'DESTINO' ], [ 'action' => 'bold' ]],
        //         [[ 'action' => 'print', 'text' => $oGroup->Fligth[2] ]], 
        //     ];
        //     $result[] = [
        //         [[ 'action' => 'print', 'text' => 'FECHA Y HORA DE COJO:' ],['action' => 'merge','lines'=>1], ['action' => 'bold']],
        //         [[ 'action' => '' ]],
        //         [[ 'action' => 'print', 'text' => $oGroup->Fligth[0] ],['action' => 'merge','lines'=>4]],
        //         [[ 'action' => 'advance', 'lines' => 0]],
        //         [[ 'action' => 'print', 'text' => 'OBSERVACIONES DE VUELO' ], [ 'action' => 'bold' ]],
        //         [[ 'action' => 'print', 'text' => $oGroup->Fligth[5] ]], 
        //     ];
        // }
        $result = array_merge($result, $this->passengerFirst ($oPassengers));
        $result[] = [];
        $result[] = [];
        $result = array_merge($result, $this->passengerSecond ($oPassengers));
        $result[] = [];
        
        if(count($oGroup->Group_Slaves)>0){
            $result[] = [[['action' => 'print', 'text' => 'GRUPOS ESCLAVOS'], [ 'action' => 'center'], ['action' => 'bold'], ['action' => 'size','lines'=>14], ['action' => 'merge','lines'=>9]]];
        }
        for($i = 0; $i < count($oGroup->Group_Slaves); $i++){
            $result[] = [];
            $result[] = [[['action' => 'print', 'text' => $oGroup->Group_Slaves[$i]->Group_Name], [ 'action' => 'center'], ['action' => 'bold'], ['action' => 'merge','lines'=>9]]];
            $result[] = [];
            $result[] = [
                [[ 'action' => 'print', 'text' => 'TOUR:' ], ['action' => 'bold']],
                [[ 'action' => '' ]],
                [[ 'action' => 'print', 'text' => $oGroup->Group_Slaves[$i]->Service_Name ],['action' => 'merge','lines'=>4]],
                [[ 'action' => 'advance', 'lines' => 0]],
                [[ 'action' => 'print', 'text' => 'FECHA INICIO' ], [ 'action' => 'bold' ]],
                [[ 'action' => 'print', 'text' => $oGroup->Group_Slaves[$i]->Group_DateStart ]], 
            ];
            if($oGroup->Group_Slaves[$i]->Group_ServiceType==2){
                $result[] = [
                    [[ 'action' => 'print', 'text' => 'ORIGEN:' ], ['action' => 'bold'],['action' => 'merge','lines'=>1]],
                    [[ 'action' => 'print', 'text' => $oGroup->Group_Slaves[$i]->Group_Origin ],['action' => 'merge','lines'=>4]],
                    [[ 'action' => 'advance', 'lines' => 0]],
                    [[ 'action' => 'print', 'text' => 'DESTINO:' ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Group_Slaves[$i]->Group_Destination ]], 
                ];
                $result[] = [
                    [[ 'action' => 'print', 'text' => 'FECHA DE RECOJO:' ], ['action' => 'bold'],['action' => 'merge','lines'=>1]],
                    [[ 'action' => 'print', 'text' =>  $oGroup->Group_Slaves[$i]->Group_DateStart.' '.$oGroup->Group_Slaves[$i]->Group_Hour ],['action' => 'merge','lines'=>4]],
                ];
            }
            if($oGroup->Group_Slaves[$i]->Group_ServiceType>2){
                $datos=explode("||", $oGroup->Group_Slaves[$i]->Service_Detail);
                $result[] = [
                    [[ 'action' => 'print', 'text' => 'VUELO:' ], ['action' => 'bold'],['action' => 'merge','lines'=>1]],
                    [[ 'action' => 'print', 'text' => $datos[4]],['action' => 'merge','lines'=>4]],
                    [[ 'action' => 'advance', 'lines' => 0]],
                    [[ 'action' => 'print', 'text' => 'NUMERO DE VUELO:' ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $datos[3] ]], 
                ];
                $result[] = [
                    [[ 'action' => 'print', 'text' => 'ORIGEN:' ], ['action' => 'bold'],['action' => 'merge','lines'=>1]],
                    [[ 'action' => 'print', 'text' => $datos[1]],['action' => 'merge','lines'=>4]],
                    [[ 'action' => 'advance', 'lines' => 0]],
                    [[ 'action' => 'print', 'text' => 'DESTINO:' ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $datos[2] ]], 
                ];
                $result[] = [
                    [[ 'action' => 'print', 'text' => 'FECHA Y HORA DE COJO:' ], ['action' => 'bold'],['action' => 'merge','lines'=>1]],
                    [[ 'action' => 'print', 'text' => $datos[0]],['action' => 'merge','lines'=>4]],
                    [[ 'action' => 'advance', 'lines' => 0]],
                    [[ 'action' => 'print', 'text' => 'OBSERVACIONES DE VUELO' ], [ 'action' => 'bold' ]],
                    [[ 'action' => 'print', 'text' => $datos[5] ]], 
                ];
            }
            $length=ceil(Count($oGroup->Group_Slaves[$i]->Providers) / 2);
            for($k = 0; $k < $length; $k++){

                $array = [
                    [[ 'action' => 'print', 'text' =>$oGroup->Group_Slaves[$i]->Providers[$k*2]->NameType ], ['action' => 'bold']],
                    [[ 'action' => '' ]],
                    [[ 'action' => 'print', 'text' => $oGroup->Group_Slaves[$i]->Providers[$k*2]->Provider ],['action' => 'merge','lines'=>4]],
                    [[ 'action' => 'advance', 'lines' => 0]],
                ];
                if(($k+1)*2<=Count($oGroup->Group_Slaves[$i]->Providers)){
                    $array_new=[
                        [[ 'action' => 'print', 'text' => $oGroup->Group_Slaves[$i]->Providers[$k*2+1]->NameType ], [ 'action' => 'bold' ]],
                        [[ 'action' => 'print', 'text' => $oGroup->Group_Slaves[$i]->Providers[$k*2+1]->Provider  ]], 
                    ];
                    $result[]=array_merge($array,$array_new);
                    
                }else{
                    $result[]=$array;
                }
            }
            $result[] = [];

            $result = array_merge( $result, $this->passengerFirst($oGroup->Group_Slaves[$i]->Passenger) );
            $result[] = [];
            $result[] = [];
            $result = array_merge( $result, $this->passengerSecond($oGroup->Group_Slaves[$i]->Passenger) );
        }
        //$result = array_merge($result, $this->passengerThird ($oPassengers));
        
        return $result;
    }

    public function passengerFirst ($oPassengers) {
        $result = [];
        $result[] = array_map ([self::class, 'text'],
        [ 'NO', 'NOMBRES', '', 'SEXO', 'DOCUMENTO', 'PAIS', 'TELEFONO', 'RESTRICCIONES/EXTRAS', '', 'OBSERVACIONES']);
        
        foreach ($oPassengers as $key => $oPassenger) {
            $result[] = array_map ([self::class, 'text'],
            [
                ($key + 1) . '',
                $oPassenger->Passenger_Name . ' ' . $oPassenger->Passenger_LastName,
                '',
                $oPassenger->Passenger_Gender == 1 ? 'M' : 'F',
                $oPassenger->TypeDocument_Name . ': ' . $oPassenger->Passenger_NoDocument,
                $oPassenger->UserCountry_Name,
                $oPassenger->Passenger_Phone,
                'RESTRICCIONES: '.$oPassenger->Passenger_Restriction ."\n". 'EXTRAS: '.$oPassenger->Passenger_Extras,
                '',
                $oPassenger->BookingTourPassenger_Remark,
            ]);
        }
        return $result;
    }

    public function passengerSecond ($oPassengers) {
        $result = [];
        $result[] = array_map ([self::class, 'text'],
        [ 'NO', 'NOMBRES', '', 'SEXO','HOTEL EN CUSCO', 'TIPO DE HABITACION', 'HOTELES', 'TREN 1', 'EQUIPAMIENTOS', 'INGRESOS']);
        
        foreach ($oPassengers as $key => $oPassenger) {
            $result[] = [
                self::text (($key + 1) . ''),
                self::text ($oPassenger->Passenger_Name . ' ' . $oPassenger->Passenger_LastName),
                self::text (''),
                self::text ($oPassenger->Passenger_Gender == 1 ? 'M' : 'F'),
                
                self::text ($oPassenger->Booking_Hotel),
                isset ($oPassenger->Current_TypeRoom) ? 
                    [
                        ['action' => 'vmerge', 'lines' => $oPassenger->Current_Count],
                        ['action' => 'print', 'text' => $oPassenger->TypeRoom_Abrv],
                        ['action' => 'wrap'],
                        ['action' => 'top']
                    ] :
                    [['action' => '']],
                self::text ($oPassenger->Passenger_Hotel),
                self::text ($oPassenger->Passenger_Train_Remark1),
                self::text ($this->mapEquipments ($oPassenger->Equipments)),
                self::text ($oPassenger->Passenger_Entrance),
            ];
        }
        return $result;
    }

    public function passengerThird ($oPassengers) {
        $result = [];
        $result[] = array_map ([self::class, 'text'],
        [ 'NO', 'NOMBRES', '', 'APELLIDOS', 'SEXO', 'TELEFONO', 'TIPO DOC.', 'NUMERO DOC.', 'PAIS', 'EQUIPAMIENTOS']);
        
        foreach ($oPassengers as $key => $oPassenger) {
            $result[] = array_map ([self::class, 'text'],
            [
                ($key + 1) . '',
                $oPassenger->Passenger_Name,
                '',
                $oPassenger->Passenger_LastName,
                $oPassenger->Passenger_Gender == 1 ? 'Masculino' : 'Femenino',
                '',
                $oPassenger->TypeDocument_Name,
                $oPassenger->Passenger_NoDocument,
                $oPassenger->UserCountry_Name,
                $this->mapEquipments ($oPassenger->Equipments),
            ]);
        }
        return $result;
    }

    private function mapEquipments($equipments) {
        return implode ('\n', array_map(function ($eq) { return $eq->Item_Name . ': ' . $eq->Quantity; }, $equipments));
    }

}