<?php
namespace App\Orm;

use \Exception;

final class Connection {

    public const MYSQL_DRIVER = 'mysql';
    public const SQLSERVER_DRIVER = 'sqlserver';

    private $serverType = null;
    private $data = null;
    private $sql = "";
    private $results = array();
    public $lastInsertId = null;
    private $_debug = null;
    /** @var ConnectionConfig */
    private $config = NULL;

    private $driver = null;

    public function __construct(ConnectionConfig $config = null) {
        $this->_debug = array(
            "printsql" => false,
            "nosql" => false,
            "printvalues" => false
        );
        $this->setConfig ($config);
        $this->setDriver(self::MYSQL_DRIVER);
        if (isset($this->config->dbDriver))
            $this->setDriver($this->config->dbDriver);
    }

    public function setConfig (ConnectionConfig $config) {
        $this->config = $config;
        if (isset($this->config->dbDriver))
            $this->setDriver($this->config->dbDriver);
    }

    public function setDriver($str) {
        switch ($str) {
            case self::SQLSERVER_DRIVER:
                $this->driver = new SqlDriver();
                $this->driver->config = $this->config;
                break;
            case self::MYSQL_DRIVER:
                $this->driver = new MysqlDriver();
                $this->driver->config = $this->config;
                break;
        }
    }

    public function debug($index, $value = null) {
        if ($value === null)
            if (array_key_exists($index, $this->_debug))
                return $this->_debug[$index];
            else
                return null;
        $this->_debug[$index] = $value;
        return $this;
    }

    private function connect():self {
        $this->conn = $this->driver->connectServer();
        return $this;
    }
    
    private function close():self {
        $this->driver->close($this->conn);
        unset($this->conn);
        return $this;
    }
    private function clearData() {
        foreach($this->data as $key => $value) {
            if ($value !== null) {
                $this->data[$key] = $this->clear($value);
            }
        }
    }
    public function limpiarTexto($str) {
        return $str;
    }
    private function clear($data) {
        return $this->driver->escapeString($this->conn, $data);
    }
    private function createSqlQuery() {
        $this->sql = $this->driver->createQuery($this->sql, $this->data);
    }
    private function executeQuery($isSelect) {
        if ($this->debug("printsql")) {
            echo $this->sql;
        }
            
        if ($this->debug("nosql")) {
            throw new Exception("SQL can't be executed");
        }

        $this->results = $this->driver->execute ($this->conn, $this->sql, $isSelect);
    }
    public function query($sql, array $data = [], $isSelect = false) {
        
        $this->data = $data;
		if ($this->debug("printvalues")) {
            var_dump($data);
        }
        $this->sql = $sql;
		try {
			$this->connect();
		} catch (Exception $ex) {
			throw $ex;
		}
		
        $this->clearData();
        $this->createSqlQuery();
		
        try {
            $this->executeQuery($isSelect);
			
			if (property_exists($this->conn, "insert_id")) {
				$this->lastInsertId = $this->conn->insert_id;
			}
            $this->close();
			
            return $this->results;
        } catch (Exception $ex) {
            $this->close();
            throw $ex;
        }
        
    }
    public function selectRow ($qry, array $data = []) {
        $rows = $this->select ($qry, $data);
        return count ($rows) ? $rows[0] : NULL;
    }
    public function select($qry, array $data = []) {
        return $this->query($qry, $data, true);
    }
}