<?php

namespace App\Modules\TourHtlCamp\Infraestructure;

use App\Modules\TourHtlCamp\Domain\TourHtlCamp;
use App\Modules\TourHtlCamp\Domain\TourHtlCampRepository;
use App\Modules\TourHtlCamp\Domain\IdTourHtlCamp;
use App\Modules\Shared\Application\ActionHandler;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Infraestructure\Requester;
use App\Modules\TourHtlCamp\Domain\THCIdTour;
use Illuminate\Support\Facades\DB;

class MysqlTourHtlCampRepository implements TourHtlCampRepository {

    public function find(THCIdTour $idTour, string $query, string $action) {
        return Requester::requestSelect(
            'CALL sp_tour_htl_camp_list(?,?,?,@sts,@cod,@msg)',
            [
                $idTour->getValue(),
                $query,
                $action
            ]
        );
    }

    public function index(IdTourHtlCamp $id) {
        return Requester::requestSelect(
            'CALL sp_tour_htl_camp_index(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

    public function insert(TourHtlCamp $value) {
        return Requester::requestInsert(
            'CALL sp_tour_htl_camp_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getDay()->getValue(),
                $value->getStatus()->getValue(),
                $value->getIdTour()->getValue(),
                $value->getIdHtlCamp()->getValue(),
            ]
        );
    }

    public function update(TourHtlCamp $value) {
        return Requester::requestUpdate(
            'CALL sp_tour_htl_camp_update(?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->getValue(),
                $value->getDay()->getValue(),
                $value->getStatus()->getValue(),
            ]
        );
    }

    public function delete(IdTourHtlCamp $id) {
        return Requester::requestUpdate(
            'CALL sp_tour_htl_camp_delete(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

}
