<?php

namespace App\Modules\RedistributionDetail\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovementDetail\Domain\IdCashMovementDetail;
use App\Modules\Invoice\Domain\IdInvoice;
use App\Modules\Redistribution\Domain\IdRedistribution;

class CreateRedistributionDetail {

    private RedistributionDetailAmount $amount;
    private IdCashMovementDetail $idCashMovementDetail;
    private IdInvoice $idInvoice;
    private IdCashMovement $idCashMovement;
    private IdRedistribution $idRedistribution;

    public function __construct(
        RedistributionDetailAmount $amount,
        IdCashMovementDetail $idCashMovementDetail,
        IdInvoice $idInvoice,
        IdCashMovement $idCashMovement,
        IdRedistribution $idRedistribution
    ) {
        $this->amount = $amount;
        $this->idCashMovementDetail = $idCashMovementDetail;
        $this->idInvoice = $idInvoice;
        $this->idCashMovement = $idCashMovement;
        $this->idRedistribution = $idRedistribution;
    }

    public function amount():RedistributionDetailAmount { return $this->amount; }
    public function idCashMovementDetail():IdCashMovementDetail { return $this->idCashMovementDetail; }
    public function idInvoice():IdInvoice { return $this->idInvoice; }
    public function idCashMovement():IdCashMovement { return $this->idCashMovement; }
    public function idRedistribution():IdRedistribution { return $this->idRedistribution; }

}