<?php

namespace App\Modules\Redistribution\Infraestructure;

use App\Modules\Redistribution\Domain\CreateRedistribution;
use App\Modules\Redistribution\Domain\RedistributionCreateRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlRedistributionCreateRepository implements RedistributionCreateRepository {
    
    public function create(CreateRedistribution $model) {
        return Requester::requestInsert(
            'CALL sp_redistribution_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $model->amount()->value(),
                $model->currency()->value(),
                $model->remark()->value(),
                $model->status()->value(),
                $model->idAdmin()->value(),
            ]
        );
    }

}