<?php

namespace App\Modules\Redistribution\Domain;

use ArrayAccess;
use ArrayIterator;
use Countable;
use IteratorAggregate;
use TypeError;

class InvoiceDataCollection implements Countable, ArrayAccess, IteratorAggregate {

    private array $data;

    public function __construct(InvoiceData ...$data) {
        $this->data = $data;
    }

    public function count(): int {
        return count($this->data);
    }

    public function getIterator(): ArrayIterator {
        return new ArrayIterator($this->data);
    }
 
    public function offsetExists($offset): bool {
        return isset($this->data[$offset]);
    }
 
    public function offsetGet($offset): InvoiceData {
        return $this->data[$offset];
    }
 
    public function offsetSet($offset, $value) : void {
        if ($value instanceof InvoiceData) {
            $this->data[$offset] = $value;
        }
        else throw new TypeError("Invalid value type");
    }
 
    public function offsetUnset($offset) : void {
        unset($this->data[$offset]);
    }

}