<?php

namespace App\Modules\PaxInformation\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\IdBooking;

interface PaxInformationRepository
{
    public function insert(
        PaxInformationDescription $description,
        PaxInformationRemaining $remaining,
        PaxInformationDateExpire $expire,
        PaxInformationStatus $status,
        IdBooking $idBooking,
        IdAdmin $idAdmin
    ):array;

    public function find(IdBooking $idBooking, string $action);

    public function index(IdPaxInformation $id);

    public function update(UpdatePaxInformation $value);
    public function use(UsePaxInformation $value);

    public function delete(IdPaxInformation $id);
}
