<?php

namespace App\Modules\PaxInformation\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\IdBooking;

final class PaxInformation
{
    public function __construct(
        private PaxInformationDate $date,
        private PaxInformationDateExpire $dateExpire,
        private PaxInformationDateModify $dateModify,
        private PaxInformationDescription $description,
        private PaxInformationTotalPassengers $totalPassengers,
        private PaxInformationToken $token,
        private PaxInformationStatus $status,
        private IdBooking $idBooking,
        private IdAdmin $idAdmin,
        private IdPaxInformation $id
    ) {
    }

    public function date():PaxInformationDate
    {
        return $this->date;
    }

    public function dateExpire():PaxInformationDateExpire
    {
        return $this->dateExpire;
    }

    public function dateModify():PaxInformationDateModify
    {
        return $this->dateModify;
    }

    public function description():PaxInformationDescription
    {
        return $this->description;
    }

    public function totalPassengers():PaxInformationTotalPassengers
    {
        return $this->totalPassengers;
    }

    public function token():PaxInformationToken
    {
        return $this->token;
    }

    public function status():PaxInformationStatus
    {
        return $this->status;
    }

    public function idBooking():IdBooking
    {
        return $this->idBooking;
    }

    public function idAdmin():IdAdmin
    {
        return $this->idAdmin;
    }

    public function id():IdPaxInformation
    {
        return $this->id;
    }
}
