<?php

namespace App\Modules\PaxInformation\Application;

use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformation\Domain\PaxInformationRepository;

class PaxInformationIndexer {

    private PaxInformationRepository $repository;

    public function __construct(PaxInformationRepository $repository) {
        $this->repository = $repository;
    }

    public function __invoke (IdPaxInformation $idPaxInformation) {
        return $this->repository->index($idPaxInformation);
    }
}