<?php

namespace App\Modules\PassengerReview\Application;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\PassengerReview\Domain\PassengerReviewSearchByGroupRepository;

class PassengerReviewSearchByGroup
{

    private PassengerReviewSearchByGroupRepository $repository;

    public function __construct(PassengerReviewSearchByGroupRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroup $idGroup, string $action, string $path)
    {
        return $this->repository->searchByGroup($idGroup, $action, $path);
    }
}
