<?php

namespace App\Modules\Passenger\Infraestructure;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\Passenger;
use App\Modules\Passenger\Domain\PassengerSearchWithReviewRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\ListInput;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPassengerSearchWithReviewRepository implements PassengerSearchWithReviewRepository
{

    public function search(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $range,
        $idGroup,
        $action,
        ListInput $listInput,
        $paginated
    ) {
        return Requester::requestSelect(
            'CALL sp_passenger_search_with_review(?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $dateStart->value(),
                $dateEnd->value(),
                $range,
                $idGroup,
                config('var.PATH_PUBLIC') . config("var.USER_COUNTRY_THUMB"),
                config('var.PATH_PUBLIC'),
                $action,
                $listInput->getOffset(),
                $listInput->getLimit(),
                $paginated
            ]
        );
    }

    public function amount(
        DateStart $dateStart,
        DateEnd $dateEnd,
        $range,
        $idGroup,
        $action
    ) {
        return Requester::requestSelect(
            'CALL sp_passenger_search_with_review_amount(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $dateStart->value(),
                $dateEnd->value(),
                $range,
                $idGroup,
                $action
            ]
        );
    }
}
