<?php
namespace App\Modules\Modules\Domain\Structure;

use App\Modules\Shared\Domain\GenerateActionException;

class ParamModuleEnum extends ParamModule
{

    public function __construct(
        private string $key,
        private array $values,
        private $defaultValue
    ) {
        parent::__construct($key, 'enum');
    }

    public function ensureIsValid($value)
    {
        if (!in_array($value, $this->values, true)) {
            (new GenerateActionException)("Invalid value for enum: $value");
        }
        return $value;
    }

    public function defaultValue()
    {
        return $this->defaultValue;
    }
}
