<?php
namespace App\Modules\Modules\Domain\Structure;

abstract class ParamModule
{
    public function __construct(
        private string $key,
        private string $type
    ) {
    }

    public static function from(
        string $key,
        string $type
    ) {
        return new ParamModule(
            $key,
            $type
        );
    }

    public function key()
    {
        return $this->key;
    }

    abstract public function defaultValue();

    abstract public function ensureIsValid($value);
}
