<?php

namespace App\Modules\Machupicchu\Application\AvailabilityList;

use App\Modules\Shared\Domain\Bus\Query\Response;

final class MachupicchuAvailabilitiesResponse implements Response
{
    private array $avaliabilities;

    public function __construct(MachupicchuAvailabilityResponse ...$avaliabilities)
    {
        $this->avaliabilities = $avaliabilities;
    }

    public function response(): array
    {
        return [
            "Response_Status" => 200,
            "Response_Code" => 200,
            "Response_Domain" => "global",
            "Response_Message" => "",
            "Response_Data" => $this->avaliabilities,
            "Response_Error_Message" => null,
            "Response_Error_Reason" => null
        ];
    }
}
