<?php

namespace App\Modules\LeadBookingTourPassenger\Application\List;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTourPassenger\Application\List\LeadBookingTourPassengerListerResponse;
use App\Modules\LeadBookingTourPassenger\Domain\LeadBookingTourPassengerRepository;

final class LeadBookingTourPassengerLister
{
    public function __construct(private LeadBookingTourPassengerRepository $repository)
    {
    }

    public function __invoke(
        IdLeadBookingTour $idLeadBookingTour,
        string $action
    ): LeadBookingTourPassengerListerResponse {
        return new LeadBookingTourPassengerListerResponse($this->repository->find($idLeadBookingTour, $action));
    }
}
