<?php

namespace App\Modules\LeadBookingTourPassenger\Application\Delete;

use App\Modules\LeadBookingTourPassenger\Domain\IdLeadBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingTourPassengerDeleterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourPassengerDeleter $inserter)
    {
    }

    public function __invoke(LeadBookingTourPassengerDeleterQuery $query): LeadBookingTourPassengerDeleterResponse
    {
        return $this->inserter->__invoke(new IdLeadBookingTourPassenger($query->getId()));
    }
}
