<?php

namespace App\Modules\LeadBookingTour\Infraestructure;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBookingTour\Domain\LeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;
use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourDateStart;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourGroup;
use App\Modules\LeadBookingTour\Domain\UpdateLeadBookingTour;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlLeadBookingTourRepository implements LeadBookingTourRepository
{

    public function findByGroup(IdLeadBooking $idLeadBooking, LeadBookingTourGroup $group, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_tour_list(?,?,@sts,@cod,@msg)',
            [
                $idLeadBooking->value(),
                $action
            ]
        );
    }

    public function find(IdLeadBooking $idLeadBooking, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_tour_list(?,?,@sts,@cod,@msg)',
            [
                $idLeadBooking->value(),
                $action
            ]
        );
    }

    public function index(IdLeadBookingTour $id)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_tour_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(LeadBookingTour $value)
    {
        return Requester::requestInsert(
            'CALL sp_lead_booking_tour_insert(?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getDateStart()->value(),
                $value->getPickUp()->value(),
                $value->getType()->value(),
                $value->getNoPax()->value(),
                $value->getGroup()->value(),
                $value->getStatus()->value(),
                $value->getIdLeadBooking()->value(),
                $value->getIdPackage()->value(),
                $value->getIdTour()->value(),
            ]
        );
    }

    public function update(UpdateLeadBookingTour $value)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_tour_update(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getDateStart()->value(),
                $value->getPickUp()->value(),
                $value->getType()->value(),
                $value->getNoPax()->value(),
                $value->getStatus()->value()
            ]
        );
    }

    public function updateDate(IdLeadBookingTour $id, LeadBookingTourDateStart $dateStart)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_tour_update_date(?,?,@sts,@cod,@msg)',
            [
                $id->value(),
                $dateStart->value()
            ]
        );
    }

    public function delete(IdLeadBookingTour $id)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_tour_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
