<?php

namespace App\Modules\LeadBookingService\Application\List;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServiceListerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServiceLister $inserter)
    {
    }

    public function __invoke(LeadBookingServiceListerQuery $query): LeadBookingServiceListerResponse
    {
        return $this->inserter->__invoke(
            new IdLeadBookingTour($query->getIdLeadBookingTour()),
            $query->getAction()
        );
    }
}
