<?php

namespace App\Modules\LeadBookingService\Application\List;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingService\Application\List\LeadBookingServiceListerResponse;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceRepository;

final class LeadBookingServiceLister
{
    public function __construct(private LeadBookingServiceRepository $repository)
    {
    }

    public function __invoke(IdLeadBookingTour $idLeadBookingTour, string $action): LeadBookingServiceListerResponse
    {
        return new LeadBookingServiceListerResponse($this->repository->find($idLeadBookingTour, $action));
    }
}
