<?php

namespace App\Modules\Lead\Application\Create;

use App\Modules\Lead\Application\Create\LeadInserterResponse;
use App\Modules\Lead\Domain\Lead;
use App\Modules\Lead\Domain\LeadRepository;

final class LeadInserter
{
    public function __construct(private LeadRepository $repository)
    {
    }

    public function __invoke(Lead $lead): LeadInserterResponse
    {
        return new LeadInserterResponse($this->repository->insert($lead));
    }
}
