<?php

namespace App\Modules\HtlUsagePassenger\Infraestructure;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlUsagePassenger\Domain\HtlUsagePassenger;
use App\Modules\HtlUsagePassenger\Domain\HtlUsagePassengerRepository;
use App\Modules\HtlUsagePassenger\Domain\HtlUsagePassengerStatus;
use App\Modules\HtlUsagePassenger\Domain\HUIdHtlRoom;
use App\Modules\HtlUsagePassenger\Domain\IdHtlUsagePassenger;
use App\Modules\Shared\Application\ActionHandler;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlHtlUsagePassengerRepository implements HtlUsagePassengerRepository {

    public function find(string $query, string $action) {
        return Requester::requestSelect(
            'CALL sp_htl_usage_passenger_list(?,?,?,@sts,@cod,@msg)',
            [
                $query,
                $action
            ]
        );
    }

    public function campFind($dateStart, $dateEnd, IdHtlCamp $idHtlCamp, string $action) {
        return Requester::requestSelect(
            'CALL sp_htl_usage_passenger_camp_list(?,?,?,?,@sts,@cod,@msg)',
            [
                $dateStart,
                $dateEnd,
                $idHtlCamp->getValue(),
                $action
            ]
        );
    }

    public function index(IdHtlUsagePassenger $id) {
        return Requester::requestSelect(
            'CALL sp_htl_usage_passenger_index(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

    public function insert(HtlUsagePassenger $value) {
        return Requester::requestInsert(
            'CALL sp_htl_usage_passenger_insert(?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getStatus()->getValue(),
                $value->getIdHtlUsage()->getValue(),
                $value->getIdBookingTourPassenger()->getValue(),
            ]
        );
    }

    public function update(HtlUsagePassenger $value) {
        return Requester::requestUpdate(
            'CALL sp_htl_usage_passenger_update(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->getValue(),
                $value->getStatus()->getValue(),
                $value->getIdHtlUsage()->getValue(),
                $value->getIdBookingTourPassenger()->getValue(),
            ]
        );
    }

    public function changeStatus(IdHtlUsagePassenger $idUsagePassenger, HtlUsagePassengerStatus $status) {
        return Requester::requestUpdate(
            'CALL sp_htl_usage_passenger_update(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $idUsagePassenger->getValue(),
                $status->getValue(),
            ]
        );
    }

    public function delete(IdHtlUsagePassenger $id) {
        return Requester::requestUpdate(
            'CALL sp_htl_usage_passenger_delete(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

}
