<?php

namespace App\Modules\HtlUsagePassenger\Domain;

use App\Modules\HtlUsage\Domain\HtlUsageStatus;

class HtlUsagePassenger {

    private HtlUsageStatus $status;
    private HUPIdHtlUsage $idHtlUsage;
    private HUPIdBookingTourPassenger $idBookingTourPassenger;
    private ?IdHtlUsagePassenger $id;


    /** constructor */
    public function __construct (
        HtlUsageStatus $status,
        HUPIdHtlUsage $idHtlUsage,
        HUPIdBookingTourPassenger $idBookingTourPassenger,
        ?IdHtlUsagePassenger $id = NULL
    ) {
        $this->status = $status;
        $this->idHtlUsage = $idHtlUsage;
        $this->idBookingTourPassenger = $idBookingTourPassenger;
        $this->id = $id;
    }

    public function getStatus():HtlUsageStatus { return $this->status; }
    public function getIdHtlUsage():HUPIdHtlUsage { return $this->idHtlUsage; }
    public function getIdBookingTourPassenger():HUPIdBookingTourPassenger { return $this->idBookingTourPassenger; }
    public function getId():IdHtlUsagePassenger { return $this->id; }

}