<?php

namespace App\Modules\Group\Application;

use App\Modules\Group\Domain\GroupProviderPassengerRepository;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

class GroupProviderPassengerFinder
{
    private GroupProviderPassengerRepository $repository;

    public function __construct(GroupProviderPassengerRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(
        IdProvider $idProvider,
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $search
    ) {
        return $this->repository->find($idProvider, $dateStart, $dateEnd, $search);
    }
}
