<?php

namespace App\Modules\ExternalReviewProvider\Infraestructure;

use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProvider;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProviderRepository;
use App\Modules\ExternalReviewProvider\Domain\IdExternalReviewProvider;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlExternalReviewProviderRepository implements ExternalReviewProviderRepository
{

    public function find($IdExternalReview, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_external_review_provider_list(?,?,@sts,@cod,@msg)',
            [
                $IdExternalReview,
                $action
            ]
        );
    }

    public function index(IdExternalReviewProvider $id)
    {
        return Requester::requestSelect(
            'CALL sp_external_review_provider_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(ExternalReviewProvider $value)
    {
        return Requester::requestInsert(
            'CALL sp_external_review_provider_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getType()->value(),
                $value->getStatus()->value(),
                $value->getIdExternalReview()->value(),
                $value->getIdGroupProvider()->value(),
            ]
        );
    }

    public function update(ExternalReviewProvider $value)
    {
        return Requester::requestUpdate(
            'CALL sp_external_review_provider_update(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getType()->value(),
                $value->getStatus()->value(),
                $value->getIdExternalReview()->value(),
                $value->getIdGroupProvider()->value(),
            ]
        );
    }

    public function delete(IdExternalReviewProvider $id)
    {
        return Requester::requestUpdate(
            'CALL sp_external_review_provider_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
