<?php

namespace App\Modules\ExternalReview\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;
use App\Modules\External\Domain\IdExternal;
use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\ExternalUserPassenger\Domain\IdExternalUserPassenger;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Language\Domain\IdLanguage;

class InsertExternalReview
{

    /** constructor */
    public function __construct(
        private ExternalReviewDateReview $dateReview,
        private ExternalReviewRoute $route,
        private ExternalReviewTitle $title,
        private ExternalReviewValue $value,
        private ExternalReviewScore $score,
        private ExternalReviewType $type,
        private ExternalReviewStatus $status,
        private IdExternalUser $idExternalUser,
        private IdExternalUserPassenger $idExternalUserPassenger,
        private IdGroupPassenger $idGroupPassenger,
        private IdBookingRelationship $idBookingRelationship,
        private IdLanguage $idLanguage,
        private IdExternal $idExternal,
        private IdAdmin $idAdmin,
        private IdExternalReview $idExternalReview_Parent
    ) {
    }
    public function getExternalReviewDateReview(): ExternalReviewDateReview
    {
        return $this->dateReview;
    }
    public function getExternalReviewRoute(): ExternalReviewRoute
    {
        return $this->route;
    }
    public function getExternalReviewTitle(): ExternalReviewTitle
    {
        return $this->title;
    }
    public function getExternalReviewValue(): ExternalReviewValue
    {
        return $this->value;
    }
    public function getExternalReviewScore(): ExternalReviewScore
    {
        return $this->score;
    }
    public function getExternalReviewType(): ExternalReviewType
    {
        return $this->type;
    }
    public function getExternalReviewStatus(): ExternalReviewStatus
    {
        return $this->status;
    }
    public function getIdExternalUser(): IdExternalUser
    {
        return $this->idExternalUser;
    }
    public function getIdExternalUserPassenger(): IdExternalUserPassenger
    {
        return $this->idExternalUserPassenger;
    }
    public function getIdGroupPassenger(): IdGroupPassenger
    {
        return $this->idGroupPassenger;
    }
    public function getIdBookingRelationship(): IdBookingRelationship
    {
        return $this->idBookingRelationship;
    }
    public function getIdLanguage(): IdLanguage
    {
        return $this->idLanguage;
    }
    public function getIdExternal(): IdExternal
    {
        return $this->idExternal;
    }
    public function getIdAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }
    public function getIdExternalReview(): IdExternalReview
    {
        return $this->idExternalReview_Parent;
    }
}
