<?php

namespace App\Modules\EmailShip\Domain;

class EmailShip {

    /** constructor */
    public function __construct (
        private EmailShipDate $date,
        private EmailShipDateResponse $dateResponse,
        private EmailShipTo $to,
        private EmailShipBcc $bcc,
        private EmailShipResponse $response,
        private EmailShipStatus $status,
        private ?IdEmailShip $id = NULL
    ) {
        $this->date = $date;
        $this->dateResponse = $dateResponse;
        $this->to = $to;
        $this->bcc = $bcc;
        $this->response = $response;
        $this->status = $status;
        $this->id = $id;
    }

    public function getDate():EmailShipDate { return $this->date; }
    public function getDateResponse():EmailShipDateResponse { return $this->dateResponse; }
    public function getTo():EmailShipTo { return $this->to; }
    public function getBcc():EmailShipBcc { return $this->bcc; }
    public function getResponse():EmailShipResponse { return $this->response; }
    public function getStatus():EmailShipStatus { return $this->status; }
    public function getId():IdEmailShip { return $this->id; }

}