<?php

namespace App\Modules\CashMovement\Infraestructure;

use App\Modules\CashMovement\Domain\CashMovementRedistributeRepository;
use App\Modules\CashMovement\Domain\RedistributeCashMovement;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlRedistributeRepository implements CashMovementRedistributeRepository
{
    public function redistribute(RedistributeCashMovement $model)
    {
        return Requester::requestInsert(
            'CALL sp_cash_movement_redistribute(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $model->datePayment()->value(),
                $model->amount()->value(),
                $model->currency()->value(),
                $model->name()->value(),
                $model->lastName()->value(),
                $model->email()->value(),
                $model->country()->value(),
                $model->city()->value(),
                $model->address()->value(),
                $model->phone()->value(),
                $model->receiptNumber()->value(),
                $model->cardLast()->value(),
                $model->cardNumber()->value(),
                $model->cardBrand()->value(),
                $model->cardType()->value(),
                $model->cardIssuer()->value(),
                $model->remark()->value(),
                $model->idTypePayment()->value(),
                $model->idAdmin()->value(),
            ]
        );
    }
}
