<?php

namespace App\Modules\CashMovement\Domain;

use App\Modules\Invoice\Domain\IdInvoice;

final class InvoiceData {

    private Amount $amount;
    private IdInvoice $idInvoice;

    public function __construct(Amount $amount, IdInvoice $idInvoice) {
        $this->amount = $amount;
        $this->idInvoice = $idInvoice;
    }

    public function amount(): Amount { return $this->amount; }
    public function idInvoice(): IdInvoice { return $this->idInvoice; }

}