<?php

namespace App\Modules\BookingTour\Infraestructure;

use App\Modules\BookingTour\Domain\BookingTourPassengerListRepository;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Shared\Application\ActionHandler;
use Illuminate\Support\Facades\DB;

class MysqlBookingTourPassengerListRepository implements BookingTourPassengerListRepository
{
    public function list(string $action, IdBookingTour $idBookingTour, $id, $pathThumb)
    {
        return DB::select(
            'call sp_booking_tour_passenger_list(?,?,?,?)',
            [
                $action,
                $idBookingTour->getValue(),
                $id,
                $pathThumb
            ]
        );
    }
}
