<?php

namespace App\Modules\BookingReferredFrom\Infraestructure;

use App\Modules\BookingReferredFrom\Domain\BookingReferredFrom;
use App\Modules\BookingReferredFrom\Domain\BookingReferredFromRepository;
use App\Modules\BookingReferredFrom\Domain\IdBookingReferredFrom;
use App\Modules\Shared\Application\ActionHandler;
use Illuminate\Support\Facades\DB;

class MysqlBookingReferredFromRepository implements BookingReferredFromRepository {

    public function insert(BookingReferredFrom $bookingReferredFrom) {
        return (new ActionHandler())->handle(DB::select(
            'call sp_booking_referred_from_insert(?,?,?,?)',
            [
                $bookingReferredFrom->getName()->getValue(),
                $bookingReferredFrom->getAbrv()->getValue(),
                $bookingReferredFrom->getLock()->getValue(),
                $bookingReferredFrom->getStatus()->getValue(),
            ]
        ));
    }

    public function update(BookingReferredFrom $bookingReferredFrom) {
        return (new ActionHandler())->handle(DB::select(
            'call sp_booking_referred_from_update(?,?,?,?)',
            [
                $bookingReferredFrom->getId()->getValue(),
                $bookingReferredFrom->getName()->getValue(),
                $bookingReferredFrom->getAbrv()->getValue(),
                $bookingReferredFrom->getStatus()->getValue(),
            ]
        ));
    }

    public function index(IdBookingReferredFrom $id) {
        return DB::select(
            'call sp_booking_referred_from_index(?)',
            [
                $id->getValue()
            ]
        );
    }

    public function list($action) {
        return DB::select(
            'call sp_booking_referred_from_list(?)',
            [
                $action
            ]
        );
    }
    
}