<?php

namespace App\Modules\Booking\Infraestructure;

use App\Modules\Booking\Domain\BookingReceiptRepository;
use App\Modules\Booking\Domain\ReceiptBooking;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlBookingReceiptRepository implements BookingReceiptRepository {

    public function changeReceipt(ReceiptBooking $model) {
        return Requester::requestInsert(
            'CALL sp_booking_receipt(?,?,@sts,@cod,@msg)',
            [
                $model->id()->value(),
                $model->currency()->value()
            ]
        );
    }

}