<?php

namespace App\Modules\Booking\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\BookingReferredFrom\Domain\IdBookingReferredFrom;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;

class InsertBookingModel {

    private BookingType $bookingType;
    private BookingStatus $bookingStatus;
    private IdAdmin $idAdmin;
    private int $idGuideLanguage;
    private int $idLanguage;
    private int $idUser;
    private IdBookingRelationship $idBookingRelationship;
    private IdBookingReferredFrom $idBookingReferredFrom;

    public function __construct(
        BookingType $bookingType,
        BookingStatus $bookingStatus,
        IdAdmin $idAdmin,
        int $idGuideLanguage,
        int $idLanguage,
        int $idUser,
        IdBookingRelationship $idBookingRelationship,
        IdBookingReferredFrom $idBookingReferredFrom
    ) {
        $this->bookingType = $bookingType;
        $this->bookingStatus = $bookingStatus;
        $this->idAdmin = $idAdmin;
        $this->idGuideLanguage = $idGuideLanguage;
        $this->idLanguage = $idLanguage;
        $this->idUser = $idUser;
        $this->idBookingRelationship = $idBookingRelationship;
        $this->idBookingReferredFrom = $idBookingReferredFrom;
    }

    public function bookingType(): BookingType { return $this->bookingType; }
    public function bookingStatus(): BookingStatus { return $this->bookingStatus; }
    public function idAdmin(): IdAdmin { return $this->idAdmin; }
    public function idGuideLanguage(): int { return $this->idGuideLanguage; }
    public function idLanguage(): int { return $this->idLanguage; }
    public function idUser(): int { return $this->idUser; }
    public function idBookingRelationship(): IdBookingRelationship { return $this->idBookingRelationship; }
    public function idBookingReferredFrom(): IdBookingReferredFrom { return $this->idBookingReferredFrom; }

    
    
}