<?php

namespace App\Modules\Booking\Domain;

class BookingStatus {

    public const NULLIFIED = 0;
    public const PENDING = 1;
    public const CONFIRMED = 2;
    public const FINALIZED = 3;
    public const DELETED = 4;

    private int $value;

    public function __construct(int $value) {
        $values = [self::NULLIFIED, self::PENDING, self::CONFIRMED, self::FINALIZED, self::DELETED];
        $this->value = in_array($value, $values) ? $value : $values[0];
    }

    public function getValue() { return $this->value; }
}