<?php

namespace App\Modules\Admin\Infrastructure;

use App\Modules\Admin\Domain\Lead;
use App\Modules\Admin\Domain\LeadRepository;
use App\Modules\Admin\Domain\IdLead;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlLeadRepository implements LeadRepository
{

    public function find(string $action)
    {
        return Requester::requestSelect(
            'CALL sp_lead_list(?,@sts,@cod,@msg)',
            [
                $action
            ]
        );
    }

    public function index(IdLead $id)
    {
        return Requester::requestSelect(
            'CALL sp_lead_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(Lead $value)
    {
        return Requester::requestInsert(
            'CALL sp_lead_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getName()->value(),
                $value->getLastName()->value(),
                $value->getGender()->value(),
                $value->getEmail()->value(),
                $value->getPhoneCode()->value(),
                $value->getPhone()->value(),
                $value->getNoDocument()->value(),
                $value->getAddress()->value(),
                $value->getContactName()->value(),
                $value->getContactPhone()->value(),
                $value->getType()->value(),
                $value->getStatus()->value(),
                $value->getIdTypeDocument()->value(),
                $value->getIdUserCountry()->value()
            ]
        );
    }

    public function update(Lead $value)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getName()->value(),
                $value->getLastName()->value(),
                $value->getGender()->value(),
                $value->getEmail()->value(),
                $value->getPhoneCode()->value(),
                $value->getPhone()->value(),
                $value->getNoDocument()->value(),
                $value->getAddress()->value(),
                $value->getContactName()->value(),
                $value->getContactPhone()->value(),
                $value->getType()->value(),
                $value->getStatus()->value(),
                $value->getIdTypeDocument()->value(),
                $value->getIdUserCountry()->value()
            ]
        );
    }

    public function delete(IdLead $id)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
