<?php

namespace App\Modules\Admin\Application\Update;

use App\Modules\Admin\Application\Update\LeadUpdaterResponse;
use App\Modules\Admin\Domain\Lead;
use App\Modules\Admin\Domain\LeadRepository;

final class LeadUpdater
{
    public function __construct(private LeadRepository $repository)
    {
    }

    public function __invoke(Lead $lead): LeadUpdaterResponse
    {
        return new LeadUpdaterResponse($this->repository->update($lead));
    }
}
