<?php

namespace App\Http\Middleware;

use App\Http\Helpers\ResponseBuilder;
use Closure;

class LockDomainMiddleware
{

    private const AVAILABLE_DOMAINS = [
        'salkantaytrekking.com',
        'caminosalkantay.com',
        'ausangateperu.com'
    ];

    public function handle($request, Closure $next)
    {
        if (!self::isInAvailable($request->headers->get('origin'))) {
            $oResponse["Response_Status"]           = 401;
            $oResponse["Response_Code"]             = 401;
            $oResponse["Response_Domain"]           = "global";
            $oResponse["Response_Message"]          = "Origin not available";
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = "Bad Request";
            $oResponse["Response_Error_Reason"]     = "Origin not available";
            
            return ResponseBuilder::Response($oResponse);
        }

        return $next($request);
    }

    public static function isInAvailable(string | null $domain)
    {
        if (!isset($domain)) {
            return true;
        }
        $length = count(self::AVAILABLE_DOMAINS);
        for ($i = 0; $i < $length; $i++) {
            if (self::AVAILABLE_DOMAINS[$i] === $domain) {
                return true;
            }
        }
        return false;
    }
}
