<?php
namespace App\Http\Helpers;

class ResponseBuilder
{
    /*
    $oResponse = array();
    $oResponse["Response_Status"]           = CODIGO HTTP DE RESPUESTA 200,400,500;
    $oResponse["Response_Code"]             = CODIGO INTERNO DE RESPUESTA;
    $oResponse["Response_Domain"]           = AMBITO DONDE SE DESARROLLA;
    $oResponse["Response_Message"]          = MENSAJE DE RESPUESTA;
    $oResponse["Response_Data"]             = DATOS QUE SE VANA  DEVOLVER;
    $oResponse["Response_Error_Reason"]     = null;
    $oResponse["Response_Error_Message"]    = null;
    */

    public static function Response($oParams)
    {
        // if (!is_array($oParams)) {
        //  return $oParams;
        // }
        $oResponse = array();

        if ($oParams["Response_Code"] == 200) {
            $Success = true;
        } else {
            $Success = false;
        }

        if ($oParams["Response_Data"] != null) {
            $Data_Count = count($oParams["Response_Data"]);
        } else {
            $Data_Count = null;
        }

        //
        // GENERA LA RESPUESTA
        //
        $oResponse["date"]          = date("d-m-Y H:i:s");
        $oResponse["code"]          = $oParams["Response_Code"];
        $oResponse["success"]       = $Success;
        $oResponse["domain"]        = $oParams["Response_Domain"];
        $oResponse["message"]       = $oParams["Response_Message"];
        $oResponse["data-count"]    = $oParams["Response_Count"] ?? $Data_Count;
        $oResponse["data"]          = $oParams["Response_Data"];
        $oResponse["error"]         = self::Response_Error($oParams);

        //
        // RETORNA LA RESPUESTA
        //
        // $oResponse = self::convert_to_utf8_recursively($oResponse);
        return response()   ->json($oResponse, $oParams["Response_Status"])
                            ->header("X-Salkantay-API-Version", "1.0.0")
                            ->header("X-Salkantay-API-Enviroment", "development");
    }

    private static function convert_to_utf8_recursively($dat)
    {
        if (is_string($dat)) {
            return mb_convert_encoding($dat, 'UTF-8', 'UTF-8');
        } elseif (is_array($dat)) {
            $ret = [];
            foreach ($dat as $i => $d) {
                $ret[$i] = self::convert_to_utf8_recursively($d);
            }
            return $ret;
        } else {
            return $dat;
        }
    }
    private static function Response_Error($oParams)
    {
        $oResponse = array();

        if ($oParams["Response_Error_Reason"] != "" and $oParams["Response_Error_Message"] != "") {
            $oResponse["message"]       = $oParams["Response_Error_Message"];
            $oResponse["reason"]        = $oParams["Response_Error_Reason"];
        } else {
            $oResponse = null;
        }
        
        return $oResponse;
    }
}
