<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;

class c_State extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct() {
		$this->oDomain = "State";
		$this->history = new HistoryData (HistoryTables::state);
	}

	public function Insert(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'State_Code'    => 'required|string|max:3',
								'State_Name'    => 'required|string|max:250',
								'State_Status'  => 'required|int',
								'Id_Country'    => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			
			
			#endregion

			#region INSERTA DATOS

			$oParam = array(    trim( $Request->input("State_Code")),
								trim( $Request->input("State_Name")),								
											$Request->input("State_Status"),
											$Request->input("Id_Country")
							);
			$oData = DB::select('call sp_state_insert(?,?,?,?)',$oParam);

			#endregion

			//  RESPONSE
			if($oData[0]->Response_Success == 1) {
				
				#region HISTORY EXEC
				$this->history->insertBasic ($Request);
				#endregion

			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(	'Id_State'		=> 'required|int',
								'State_Code'    => 'required|string|max:3',
								'State_Name'    => 'required|string|max:250',
								'State_Status'  => 'required|int',
								'Id_Country'    => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			$this->history->obtainOld($Request->input('Id_State'));

			#region ACTUALIZA DATOS

			$oParam = array(    			$Request->input("Id_State"),
								trim( $Request->input("State_Code")),
								trim( $Request->input("State_Name")),								
											$Request->input("State_Status"),
											$Request->input("Id_Country")
							);
			$oData = DB::select('call sp_state_update(?,?,?,?,?)',$oParam);

			#endregion

			//  RESPONSE
			if($oData[0]->Response_Success == 1) {
				
				#region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_State"), $Request );
				#endregion

			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			$this->history->obtainOld($Id);

			#region ELIMINA DATOS

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_state_delete(?)',$oParam);

			#endregion

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
				#region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				#endregion

			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_state_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request,$Id_Country, $Id){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_Country,"Country");

		if ($oResponse["Response_Code"] == 200) {

			$oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

			if ($oResponse["Response_Code"] == 200) {
				$oParam = array( $Id, $Id_Country );
				$oData  = DB::select('call sp_state_list(?,?)',$oParam);

				$oResponse["Response_Status"]			= 200;
				$oResponse["Response_Code"]				= 200;
				$oResponse["Response_Domain"]			= $this->oDomain;
				$oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
				$oResponse["Response_Data"]				= $oData;
				$oResponse["Response_Error_Message"]	= "";
				$oResponse["Response_Error_Reason"]		= "";
			}
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	
}