<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Providers\HtlCampMailSender;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\HtlCamp\Application\HtlCampDeleter;
use App\Modules\HtlCamp\Application\HtlCampFinder;
use App\Modules\HtlCamp\Application\HtlCampIndexer;
use App\Modules\HtlCamp\Application\HtlCampInserter;
use App\Modules\HtlCamp\Application\HtlCampUpdater;
use App\Modules\HtlCamp\Domain\HtlCamp;
use App\Modules\HtlCamp\Domain\HtlCampAbrv;
use App\Modules\HtlCamp\Domain\HtlCampAvailability;
use App\Modules\HtlCamp\Domain\HtlCampName;
use App\Modules\HtlCamp\Domain\HtlCampStatus;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlCamp\Infraestructure\HtlCampValidators;
use App\Modules\HtlCamp\Infraestructure\MysqlHtlCampRepository;
use App\Modules\Shared\Infraestructure\LaravelExceptionHandler;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Throwable;

class c_HtlCamp extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "HtlCamp";
        $this->history = new HistoryData(HistoryTables::htl_camp);
    }

    // public static function getHistoryData ($Id_HtlCamp) {
    //  $invoiceListJSON = json_encode (HtlCampMailSender::GetInvoiceList($Id_HtlCamp));
    //  return self::GetReportData($Id_HtlCamp, $invoiceListJSON);
    // }

    public function Insert(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlCampValidators::insert);
        
        $oResponse = (new HtlCampInserter(new MysqlHtlCampRepository))->__invoke(
            new HtlCamp(
                new HtlCampName (Str::title($Request->input('HtlCamp_Name'))),
                new HtlCampAbrv (Str::upper($Request->input('HtlCamp_Abrv'))),
                new HtlCampAvailability (1),
                new HtlCampStatus ($Request->input('HtlCamp_Status')),
            )
        );

        $this->history->insert(
            (new HtlCampIndexer(new MysqlHtlCampRepository))->__invoke(new IdHtlCamp($oResponse['Response_Data']['Id'])),
            $Request,
            $oResponse['Response_Data']['Id']
        );
        
        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, HtlCampValidators::update);

        $this->history->obtainOld($Request->input('Id_HtlCamp'));

        $oResponse = (new HtlCampUpdater(new MysqlHtlCampRepository))->__invoke(
            new HtlCamp(
                new HtlCampName(Str::title($Request->input('HtlCamp_Name'))),
                new HtlCampAbrv(Str::upper($Request->input('HtlCamp_Abrv'))),
                new HtlCampAvailability(1),
                new HtlCampStatus($Request->input('HtlCamp_Status')),
                new IdHtlCamp($Request->input('Id_HtlCamp'))
            )
        );

        $this->history->update(
            $Request->input('Id_HtlCamp'),
            $this->history->oldValue,
            [],
            $Request
        );
        return ResponseBuilder::Response($oResponse);
    }
    
    public function Delete(Request $request, $Id)
    {
        try {
            return $this->DeleteFunction($request, $Id);
        } catch (Throwable $ex) {
            return (new LaravelExceptionHandler())->handle($ex);
        }
    }

    public function DeleteFunction(Request $request, $Id)
    {

        $this->history->obtainOld($Id);

        $oResponse = (new HtlCampDeleter(new MysqlHtlCampRepository))->__invoke(new IdHtlCamp($Id));
                
        $this->history->delete(
            $Id,
            $this->history->oldValue,
            $request
        );
                
        return ResponseBuilder::Response($oResponse);
    }

    public function Index($Id)
    {
        $oResponse = (new HtlCampIndexer(new MysqlHtlCampRepository))->__invoke(new IdHtlCamp($Id));
        return ResponseBuilder::Response($oResponse);
    }

    public function List($Action, Request $Request)
    {
        $query = $Request->input("query") ? $Request->input("query") : '';
        $oResponse = (new HtlCampFinder(new MysqlHtlCampRepository))->__invoke($Action, $query);
        return ResponseBuilder::Response($oResponse);
    }
}
