<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Intervention\Image\ImageManagerStatic as Image;

class c_Group_Activity_Detail extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Group Activity Detail";
		$this->history = new HistoryData (HistoryTables::group_activity_detail);
	}

	public static function findGroup ($Id_GroupDetailActivity) {
		$found = DB::select ('CALL sp_group_activity_detail_index(?)', [$Id_GroupDetailActivity]);
		return count ($found) ? $found[0]->Id_Group : null;
	}

	public function Insert (Request $Request) {
		$oResponse  = array();
		$oValParams = array(    'GroupActivityDetail_Code'       	=> 'required|string|max:100',
								'GroupActivityDetail_Date' 			=> 'required|string|max:100',
								'GroupActivityDetail_Description'	=> 'required|string',
								'Id_GroupActivity'               	=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    Str::upper( $Request->input("GroupActivityDetail_Code")),
											$Request->input("GroupActivityDetail_Date").':00',
											$Request->input("GroupActivityDetail_Description"),
											$Request->input("Id_GroupActivity")
							);
			$oData = DB::select('call sp_group_activity_detail_insert(?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$this->history->insert (
					[$Request->all()],
					$Request,
					c_Group_Activity::findGroup ($Request->input("Id_GroupActivity"))
				);
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(	'Id_GroupActivityDetail'         	=> 'required|int',
								'GroupActivityDetail_Code'       	=> 'required|string|max:100',
								'GroupActivityDetail_Date' 			=> 'required|string|max:100',
								'GroupActivityDetail_Description'	=> 'required|string',
								'Id_GroupActivity'               	=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$this->history->obtainOld();
			$oParam = array(    			$Request->input("Id_GroupActivityDetail"),
								Str::upper( $Request->input("GroupActivityDetail_Code")),
											$Request->input("GroupActivityDetail_Date").':00',
											$Request->input("GroupActivityDetail_Description"),
											$Request->input("Id_GroupActivity")
							);
			$oData = DB::select('call sp_group_activity_detail_update(?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$this->history->update (
					c_Group_Activity::findGroup($Request->input('Id_GroupActivity')),
					$this->history->oldValue,
					[$Request->all()],
					$Request
				);
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$this->history->obtainOld($Id);
			$Id_Group=self::findGroup($Id);
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_group_activity_detail_delete(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$this->history->delete (
					$Id_Group,
					$this->history->oldValue,
					$Request
				);
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_group_activity_detail_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	} 
	public function List(Request $Request, $Id_GroupActivity){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_GroupActivity,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_GroupActivity );
			$oData  = DB::select('call sp_group_activity_detail_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	
}