<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;


use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingEquipmentPassenger\Infraestructure\BookingEquipmentPassengerValidators;
use App\Modules\Shared\Application\ActionHandler;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;

class c_Booking_Equipment_Passenger extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Booking Equipment Passenger";
		$this->history = new HistoryData (HistoryTables::booking_equipment_passenger);
	}

	public static function findBooking ($Id_BookingEquipmentPassenger) {
		$found = DB::select ('SELECT `fn_booking_tour_detail_passenger_find_booking`(?,?) as Id_Booking', [$Id_BookingEquipmentPassenger, 3]);
		return count($found) ? $found[0]->Id_Booking : null;
	}
	
	public function Insert_All(Request $Request){
		$oSucces	= true;
		$oResponse  = array();
		$oValParams = array(    'Id_BookingEquipment'	=> 'required|int',
								'Passenger'			=> 'required|string'
							);
		
		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
				
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			$Id_Booking = c_Booking_Equipment::findBooking($Request->input('Id_BookingEquipment'));
			
			$oPassenger = json_decode($Request->input("Passenger"));

			for($k = 0; $k < count($oPassenger); $k++){				
				$oParam = array(    $Request->input("Id_BookingEquipment"),
									$oPassenger[$k]->Id_BookingTourPassenger,
									1,
									$Request->header("Token")
							);
				$oData = DB::select('call sp_booking_equipment_passenger_insert(?,?,?,?)',$oParam);
				
				if($oData[0]->Response_Success == 0){
					$oSucces = false;
					break;
				}

				$this->history->insert(
					[[
						'Id_BookingEquipment' => $Request->input("Id_BookingEquipment"),
						'Id_BookingTourPassenger' => $oPassenger[$k]->Id_BookingTourPassenger
					]],
					$Request,
					$Id_Booking
				);
			}

			if($oSucces == true){
				$oData = array(
					array(
						"Response_Status" 	=> 200,
						"Response_Code" 	=> 200,
						"Response_Message" 	=> "Pasajeros guardados con éxito",
						"Response_Reason" 	=> null
					)
				);

				$oData = json_decode(json_encode($oData));
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}

    public function validateData($data, $params) {
		$arrayData = (array)$data;
        $response = ParamsValidator::Validate_Data($arrayData, $params, $this->oDomain);
        if (!$this->checkResponse($response)) {
            throw new InvalidRequestException($response);
        }
    }

    /** check if response has a valid response code */
    private function checkResponse($response) {
        return $response['Response_Code'] == 200;
    }

    public function insertBookingEquipmentPassenger($Id_BookingEquipment, $Id_BookingTourPassenger) {
        
        $response = DB::select('call sp_booking_equipment_passenger_insert(?,?,?,?)', [$Id_BookingEquipment, $Id_BookingTourPassenger, 1, $this->appendedRequest->header("Token")]);
        $oResponse = Requester::generateResponse($response, $this->oDomain);
        if (!$this->checkResponse($oResponse)) {
            throw new InvalidRequestException($oResponse);
        }
        
        $this->history->insert(
            [[
                'Id_BookingEquipment' => $Id_BookingEquipment,
                'Id_BookingTourPassenger' => $Id_BookingTourPassenger
            ]],
            $this->appendedRequest,
            $this->Id_Booking
        );
        return $oResponse;
    }

    public function deleteBookingEquipmentPassenger($Id_BookingEquipmentPassenger) {
        $this->history->obtainOld($Id_BookingEquipmentPassenger);
        $response = DB::select('call sp_booking_equipment_passenger_delete(?,?)', [$Id_BookingEquipmentPassenger, 1]);
        $oResponse = Requester::generateResponse($response, $this->oDomain);
        if (!$this->checkResponse($oResponse)) {
            throw new InvalidRequestException($oResponse);
        }
        $this->history->delete (
            $this->Id_Booking,
            $this->history->oldValue,
            $this->appendedRequest
        );
        return $oResponse;
    }

    public function findPassenger ($Id_BookingEquipment, $Id_BookingTourPassenger, &$bookingEquipmentList) {
        $length = count($bookingEquipmentList);
        for ($k = 0; $k < $length; $k++) {
            if ($bookingEquipmentList[$k]->Id_BookingEquipment == $Id_BookingEquipment && $bookingEquipmentList[$k]->Id_BookingTourPassenger == $Id_BookingTourPassenger) {
                $bookingEquipmentList[$k]->found = true;
                return $bookingEquipmentList[$k];
            }
        }
        return null;
    }

    public function updatePassenger($passenger, $Id_BookingEquipment, &$bookingEquipmentPassenger) {
        $find = $this->findPassenger ($Id_BookingEquipment, $passenger['Id_BookingTourPassenger'], $bookingEquipmentPassenger);
		
        if (!$find) {
            $this->insertBookingEquipmentPassenger($Id_BookingEquipment, $passenger['Id_BookingTourPassenger']);
			return true;
        }
        return false;
    }

    public function updateBE($be) {
        
        $bookingEquipmentPassenger = DB::select('CALL sp_booking_equipment_passenger_list(?)', [$be['Id_BookingEquipment']]);

        $result = array_map (fn($passenger) => $this->updatePassenger($passenger, $be['Id_BookingEquipment'], $bookingEquipmentPassenger), $be['Passengers']);
		$deleted = 0;
		$inserted = array_reduce($result, fn($acc, $item) => $item ? $acc + 1 : $acc, 0);
        foreach($bookingEquipmentPassenger as $passenger) {
            if (!isset($passenger->found)) {
                $response = $this->deleteBookingEquipmentPassenger($passenger->Id_BookingEquipmentPassenger);
				$deleted ++;
            }
        }
		return [
			'BookingEquipmentPassenger_Inserted' => $inserted,
			'BookingEquipmentPassenger_Deleted' => $deleted
		];
    }

	private function insertBookingEquipment($Id_Equipment, $Id_BookingTour) {
		(new ActionHandler())
		->handle(DB::select(
			'CALL sp_booking_equipment_insert(?,?,?,?,?,@Response_Id)',
			[0, 1, $Id_BookingTour, $Id_Equipment, 1]
		));
		return DB::select('SELECT @Response_Id AS id')[0]->id;
	}

    public function insertBookingEquipmentAndPassengers($ep) {

		$Id_BookingEquipment = $this->insertBookingEquipment($ep['Id_Equipment'], $ep['Id_BookingTour']);
		$result = array_map (fn($passenger) => $this->insertBookingEquipmentPassenger($Id_BookingEquipment, $passenger['Id_BookingTourPassenger']), $ep['Passengers']);
        $inserted = array_reduce($result, fn($acc, $item) => $item ? $acc + 1 : $acc, 0);

		return [
			'BookingEquipmentPassenger_Inserted' => $inserted
		];
    }

    public function findEquipment ($Id_Equipment, $Id_BookingTour, &$bookingEquipmentList) {
        foreach ($bookingEquipmentList as $be) {
            if ($this->isEquipment($be, $Id_BookingTour, $Id_Equipment)) {
                $be->found = true;
                return $be;
            }
        }
        return null;
    }

	public function isEquipment($be, $Id_BookingTour, $Id_Equipment) {
		return $be->Id_BookingTour == $Id_BookingTour && $be->Id_Equipment == $Id_Equipment;
	}

	private function convertUpdateAll(Request $Request) {
		return [
			'BookingEquipment' => json_decode($Request->input('BookingEquipment'), true),
			'Equipment' => json_decode($Request->input('Equipment'), true)
		];
	}
	
	public function Update_All(Request $Request) {
        
		$this->appendedRequest = $Request;
        $this->validateData($Request->all(), BookingEquipmentPassengerValidators::UpdateAll);
		
		$data = $this->convertUpdateAll($Request);
        $this->validateData($data, BookingEquipmentPassengerValidators::UpdateAllDecoded);
        
        $this->Id_Booking = c_Booking_Equipment::findBooking($Request->input('Id_BookingEquipment'));

        $response = [
			'BookingEquipment' => array_map(fn($be) => $this->updateBE($be), $data['BookingEquipment']),
        	'Equipment' => array_map(fn($be) => $this->insertBookingEquipmentAndPassengers($be), $data['Equipment'])
		];

        return ResponseBuilder::Response([
			"Response_Status"       	=> 200,
			"Response_Code"         	=> 200,
			"Response_Domain"       	=> $this->oDomain,
			"Response_Message"      	=> 'Equipamientos actualizados con éxito',
			"Response_Data"         	=> $response,
			"Response_Error_Message"	=> '',
			"Response_Error_Reason" 	=> '',
		]);

    }

    public function Insert(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'Id_BookingEquipment'       => 'required|int',
                                'Id_BookingTourPassenger'   => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $Id_Booking = c_Booking_Extra::findBooking($Request->input('Id_BookingExtra'));
            
    		$oParam = array(    $Request->input("Id_BookingEquipment"),
								$Request->input("Id_BookingTourPassenger"),
								1,
								$Request->header("Token"),
							);
			$oData = DB::select('call sp_booking_equipment_passenger_insert(?,?,?,?)',$oParam);

			if ($oData[0]->Response_Success == 1) {
				$this->history->insert(
					[ $Request->all() ],
					$Request,
					$Id_Booking
				);
			} else {
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_BookingEquipmentPassenger' 	=> 'required|int',
								'Id_BookingEquipment'			=> 'required|int',
								'Id_BookingTourPassenger'		=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$this->history->obtainOld ($Request->input("Id_BookingEquipmentPassenger"));

			$oParam = array(	$Request->input("Id_BookingEquipmentPassenger"),
								$Request->input("Id_BookingEquipment"),
								$Request->input("Id_BookingTourPassenger")
							);
			$oData = DB::select('call sp_booking_equipment_passenger_update(?,?,?)',$oParam);

			if ($oData[0]->Response_Success == 1) {
				$this->history->update (
					$this->findBooking($Request->input("Id_BookingEquipmentPassenger")),
					$this->history->oldValue,
					[$Request->all()],
					$Request
				);
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$this->history->obtainOld($Id);

			$oParam = array( $Id, 0 );
			$oData 	= DB::select('call sp_booking_equipment_passenger_delete(?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				$this->history->delete (
					$this->findBooking($Id),
					$this->history->oldValue,
					$Request
				);
			} else {
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_booking_equipment_passenger_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_BookingEquipment){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_BookingEquipment, $this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_BookingEquipment );
			$oData  = DB::select('call sp_booking_equipment_passenger_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	
}