<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;

class c_BookingUpgradeExtraEquipment extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Booking Upgrade - Extra - Equipment";
    }
    
	public function List (Request $Request, $Id_BookingTour) {
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_BookingTour,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {		

            $oData  = array_merge (
                array_map (
                    function ($upgrade) {
						
                        $upgrade->id = $upgrade->Id_BookingUpgrade;
                        $upgrade->cant = $upgrade->BookingUpgrade_Quantity;
                        $upgrade->price = $upgrade->BookingUpgrade_Price;
                        $upgrade->total = $upgrade->BookingUpgrade_Total;
                        $upgrade->name = $upgrade->Upgrade_Name;
                        $upgrade->type = 1;
                        return $upgrade;
                    }, DB::select ('call sp_booking_upgrade_list(?)', [ $Id_BookingTour]),
                ),
                array_map (
                    function ($extra) {
						
                        $extra->id = $extra->Id_BookingExtra;
                        $extra->cant = $extra->BookingExtra_Quantity;
                        $extra->price = $extra->BookingExtra_Price;
                        $extra->total = $extra->BookingExtra_Total;
                        $extra->name = $extra->Extra_Name;
                        $extra->type = 2;
                        return $extra;
                    }, DB::select ('call sp_booking_extra_list(?)', [ $Id_BookingTour]),
                ),
                array_map (
                    function ($equipment) {
						
                        $equipment->id = $equipment->Id_BookingEquipment;
                        $equipment->cant = $equipment->BookingEquipment_Quantity;
                        $equipment->price = $equipment->BookingEquipment_Price;
                        $equipment->total = $equipment->BookingEquipment_Total;
                        $equipment->name = $equipment->Item_Name;
                        $equipment->type = 3;
                        return $equipment;
                    }, DB::select ('call sp_booking_equipment_list(?)', [ $Id_BookingTour]),
                ),
            );

            $oResponse["Response_Status"]			= 200;
            $oResponse["Response_Code"]				= 200;
            $oResponse["Response_Domain"]			= $this->oDomain;
            $oResponse["Response_Message"]			= $this->oDomain." list ".$Id_BookingTour;
            $oResponse["Response_Data"]				= $oData;
            $oResponse["Response_Error_Message"]	= "";
            $oResponse["Response_Error_Reason"]		= "";
			
		}

		return ResponseBuilder::Response($oResponse);
	}
	
	
}