<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingRelationship\Application\BookingRelationshipInserter;
use App\Modules\BookingRelationship\Application\BookingRelationshipUpdater;
use App\Modules\BookingRelationship\Domain\BookingRelationship;
use App\Modules\BookingRelationship\Domain\BookingRelationshipAbrv;
use App\Modules\BookingRelationship\Domain\BookingRelationshipLock;
use App\Modules\BookingRelationship\Domain\BookingRelationshipName;
use App\Modules\BookingRelationship\Domain\BookingRelationshipStatus;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;
use App\Modules\BookingRelationship\Infraestructure\BookingRelationshipValidators;
use App\Modules\BookingRelationship\Infraestructure\MysqlBookingRelationshipRepository;
use App\Modules\Shared\Infraestructure\LaravelExceptionHandler;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;
use Throwable;

class c_BookingRelationship extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Booking Relationship";
        $this->history = new HistoryData (HistoryTables::booking_relationship);
    }

    public function Insert(Request $Request) {

        (new LaravelValidator)->validate($Request->all(), $this->oDomain, BookingRelationshipValidators::insert);
        
        $service = new BookingRelationshipInserter(new MysqlBookingRelationshipRepository);

        $data = $service->__invoke(new BookingRelationship(
            new BookingRelationshipName(Str::title( $Request->input("BookingRelationship_Name"))),
            new BookingRelationshipAbrv(Str::upper( $Request->input("BookingRelationship_Abrv"))),
            new BookingRelationshipLock(BookingRelationshipLock::ANSWER_NO),
            new BookingRelationshipStatus( $Request->input("BookingRelationship_Status") )
        ));
        
        #region HISTORY EXEC
        $this->history->insertBasic ($Request);
        #endregion
        $response = [
            "Response_Status"           => $data[0]->Response_Status,
            "Response_Code"             => $data[0]->Response_Code,
            "Response_Domain"           => $this->oDomain,
            "Response_Message"          => $data[0]->Response_Message,
            "Response_Data"             => [ 'Id' => $data[0]->Response_Id ],
            "Response_Error_Message"    => $data[0]->Response_Message,
            "Response_Error_Reason"     => $data[0]->Response_Reason,
        ];
        
        return ResponseBuilder::Response($response);
        
    }

    public function Update(Request $Request) {

        (new LaravelValidator)->validate($Request->all(), $this->oDomain, BookingRelationshipValidators::update);
        $oResponse  = array();

        #region HISTORY VARIABLES
        $this->history->obtainOld($Request->input('Id_BookingRelationship'));
        #endregion

        #region ACTUALIZA DATOS
        $service = new BookingRelationshipUpdater(new MysqlBookingRelationshipRepository);
        $data = $service->__invoke(new BookingRelationship(
            new BookingRelationshipName(Str::title( $Request->input("BookingRelationship_Name"))),
            new BookingRelationshipAbrv(Str::upper( $Request->input("BookingRelationship_Abrv"))),
            new BookingRelationshipLock(BookingRelationshipLock::ANSWER_NO),
            new BookingRelationshipStatus($Request->input("BookingRelationship_Status")),
            new IdBookingRelationship($Request->input("Id_BookingRelationship"))
        ));
        #endregion

        #region HISTORY EXEC
        $this->history->updateBasic ( $Request->input("Id_BookingRelationship"), $Request );
        #endregion

        $oResponse["Response_Status"]           = $data[0]->Response_Status;
        $oResponse["Response_Code"]             = $data[0]->Response_Code;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $data[0]->Response_Message;
        $oResponse["Response_Data"]             = null;
        $oResponse["Response_Error_Message"]    = $data[0]->Response_Message;
        $oResponse["Response_Error_Reason"]     = $data[0]->Response_Reason;

        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            
            #region HISTORY
            $this->history->obtainOld($Id);
            #endregion

            #region ELIMINA DATOS

            $oParam = array( $Id );
            $oData  = DB::select('call sp_booking_relationship_delete(?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic ($Id, $Request);
                #endregion

            }else{
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array( $Id );
            $oData  = DB::select('call sp_booking_relationship_index(?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function List(Request $Request, $Id){
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_booking_relationship_list(?)',$oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Selector(Request $Request,$Id){
        if( is_numeric($Id) ){
            return SELF::Index( $Request,$Id );
        }else{
            return SELF::List( $Request,$Id );
        }
    }
        
}