<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Admin\Infrastructure\AdminValidators;
use App\Modules\Shared\Infraestructure\LaravelExceptionHandler;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;
use Throwable;

class c_Admin extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Admin Session";
        $this->history = new HistoryData (HistoryTables::admin);
    }
    public function Insert(Request $Request)
    {
        $Password  = array();
        $oResponse  = array();
        $oValParams = array(    'Admin_Name'             => 'required|string|max:100',
                                'Admin_LastName'         => 'required|string|max:100',
                                'Admin_Abrv'             => 'required|string|max:4',
                                'Admin_NoDocument'       => 'required|int',
                                'Admin_Email'            => 'required|string|max:250',
                                'Admin_Address'          => 'required|string|max:250',
                                'Admin_Phone'            => 'required|string',
                                'Admin_Color'            => 'required|string|max:250',
                                'Admin_Status'           => 'required|int',
                                'Id_TypeDocument'        => 'required|int',
                                'Id_AdminRole'           => 'required|int',
                                'Id_Country'             => 'required|int',
                                'Id_State'               => 'required|int',
                                'Id_City'                => 'required|int'
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {           
            $oParam = array(    Str::title( $Request->input("Admin_Name")),
                                Str::title( $Request->input("Admin_LastName")), 
                                Str::upper( $Request->input("Admin_Abrv")),                     
                                            $Request->input("Admin_NoDocument"),                            
                                            $Request->input("Admin_Email"),
                                            $Request->input("Admin_Address"),
                                            $Request->input("Admin_Phone"),
                                            $Request->input("Admin_Color"),
                                            $Request->input("Admin_Status"),
                                            $Request->input("Id_TypeDocument"),
                                            $Request->input("Id_AdminRole"),
                                            $Request->input("Id_Country"),
                                            $Request->input("Id_State"),
                                            $Request->input("Id_City")
                            );
            $oData = DB::select('call sp_admin_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?)',$oParam);
            $Password[0]=null;
            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $Password['Id_Admin'] = $oData[0]->Response_Id;
                #region HISTORY EXEC
                $this->history->insertBasic ($Request);
                #endregion
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $Password;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
        
    }
    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_Admin'               => 'required|int',
                                'Admin_Name'             => 'required|string|max:100',
                                'Admin_LastName'         => 'required|string|max:100',
                                'Admin_Abrv'             => 'required|string|max:4',
                                'Admin_NoDocument'       => 'required|int',
                                'Admin_Email'            => 'required|string|max:250',
                                'Admin_Address'          => 'required|string|max:250',
                                'Admin_Phone'            => 'required|string',
                                'Admin_Color'            => 'required|string|max:250',
                                'Admin_Status'           => 'required|int',
                                'Id_TypeDocument'        => 'required|int',
                                'Id_AdminRole'                => 'required|int',
                                'Id_Country'             => 'required|int',
                                'Id_State'               => 'required|int',
                                'Id_City'                => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            #region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_Admin'));
            #endregion

            $oParam = array(                $Request->input("Id_Admin"),
                                Str::title( $Request->input("Admin_Name")),
                                Str::title( $Request->input("Admin_LastName")), 
                                Str::upper( $Request->input("Admin_Abrv")), 
                                            $Request->input("Admin_NoDocument"),                            
                                            $Request->input("Admin_Email"),
                                            $Request->input("Admin_Address"),
                                            $Request->input("Admin_Phone"),
                                            $Request->input("Admin_Color"),
                                            $Request->input("Admin_Status"),
                                            $Request->input("Id_TypeDocument"),
                                            $Request->input("Id_AdminRole"),
                                            $Request->input("Id_Country"),
                                            $Request->input("Id_State"),
                                            $Request->input("Id_City")
                            );
            $oData = DB::select('call sp_admin_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->updateBasic ( $Request->input("Id_Admin"), $Request );
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }
    public function Delete(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            
            #region HISTORY
            $this->history->obtainOld($Id);
            #endregion

            $oParam = array( $Id );
            $oData  = DB::select('call sp_admin_delete(?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic ($Id, $Request);
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function IndexToken(Request $Request){
        $oResponse  = array();
        
        $oParam = array( $Request->header("Token") );
        $oData  = DB::select('call sp_admin_index_token(?)',$oParam);
        
        $oResponse["Response_Status"]           = 200;
        $oResponse["Response_Code"]             = 200;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $this->oDomain." Index";
        $oResponse["Response_Data"]             = $oData;
        $oResponse["Response_Error_Message"]    = "";
        $oResponse["Response_Error_Reason"]     = "";
        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array( $Id );
            $oData  = DB::select('call sp_admin_index(?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function List(Request $Request, $Id){
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_admin_list(?)',$oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Selector(Request $Request,$Id){
        if( is_numeric($Id) ){
            return SELF::Index( $Request,$Id );
        }else{
            return SELF::List( $Request,$Id );
        }
    }

    public function Password(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'Admin_Password'        => 'required|string|max:250',
                                'Admin_Password_New'    => 'required|string|max:250'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {           
            $oParam = array(    $Request->header("Token"),
                                $Request->input("Admin_Password"),
                                $Request->input("Admin_Password_New")
                            );
            $oData = DB::select('call sp_admin_update_current_password(?,?,?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                
            }else{
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }

    public function ChangePassword(Request $request) {
        try {
            return $this->ChangePasswordFunction($request);
        } catch (Throwable $ex) {
            return (new LaravelExceptionHandler())->handle($ex);
        }
    }

    public function ChangePasswordFunction(Request $Request)
    {
        $oResponse  = array();
        
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, AdminValidators::CHANGE_PASSWORD);
        
        $oParam = [
            $Request->input('Id_Admin'),
            $Request->header('Token'),
            $Request->input("Admin_Password"),
            $Request->input("Admin_Password_New")
        ];

        $oData = DB::select('call sp_admin_update_password(?,?,?,?)',$oParam);

        //  RESPONSE
        if ($oData[0]->Response_Success == 1) {
            
        }else{
            
        }
        
        $oResponse["Response_Status"]           = $oData[0]->Response_Status;
        $oResponse["Response_Code"]             = $oData[0]->Response_Code;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $oData[0]->Response_Message;
        $oResponse["Response_Data"]             = null;
        $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
        $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        

        return ResponseBuilder::Response($oResponse);

    }
        
        
}