<?php
namespace App\Http\Controllers\Owner\ReviewNotification;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ReviewNotification\Application\Update\ReviewNotificationUpdaterQuery;
use App\Modules\ReviewNotification\Application\Update\ReviewNotificationUpdaterResponse;
use App\Modules\ReviewNotification\Infraestructure\ReviewNotificationValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ReviewNotificationUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ReviewNotification";
        $this->history = new HistoryData(HistoryTables::REVIEW_NOTIFICATION);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ReviewNotificationValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_ReviewNotification"));

        /** @var ReviewNotificationUpdaterResponse $response */
        $response = $this->queryBus->ask(new ReviewNotificationUpdaterQuery(
            $request->input('Id_ReviewNotification'),
            $request->input('ReviewNotification_Description'),
            $request->input('ReviewNotification_Status')
        ));

        $this->history->updateBasic($request->input("Id_ReviewNotification"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
