<?php
namespace App\Http\Controllers\Owner\ReviewNotification;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\AdminSession\Application\Index\AdminSessionGetterQuery;
use App\Modules\ReviewNotification\Application\Create\ReviewNotificationInserterQuery;
use App\Modules\ReviewNotification\Application\Create\ReviewNotificationInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ReviewNotification\Infraestructure\ReviewNotificationValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ReviewNotificationInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ReviewNotification";
        $this->history = new HistoryData(HistoryTables::REVIEW_NOTIFICATION);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ReviewNotificationValidators::INSERT);
        
        /** @var AdminSessionGetterResponse */
        $admin = $this->queryBus->ask(new AdminSessionGetterQuery($request->header('Token')));

        /** @var ReviewNotificationInserterResponse $response */
        $response = $this->queryBus->ask(new ReviewNotificationInserterQuery(
            $request->input('ReviewNotification_Description'),
            $request->input('ReviewNotification_Status'),
            $request->input('Id_GroupPassenger'),
            $admin->response()[0]->Response_Id_Admin
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
